#include <math.h>
#include "colors.h"

/*! Generates a color corresponding to a given light wavelength lambda.
    Code taken from the Qt Example "mandelbrot".
*/
uint rgbFromWaveLength(double lambda)
{
    double r = 0.0, g = 0.0, b = 0.0;

    if (lambda >= 380.0 && lambda <= 440.0) {
        r = -1.0 * (lambda - 440.0) / (440.0 - 380.0);
        b = 1.0;
    } else if (lambda >= 440.0 && lambda <= 490.0) {
        g = (lambda - 440.0) / (490.0 - 440.0);
        b = 1.0;
    } else if (lambda >= 490.0 && lambda <= 510.0) {
        g = 1.0;
        b = -1.0 * (lambda - 510.0) / (510.0 - 490.0);
    } else if (lambda >= 510.0 && lambda <= 580.0) {
        r = (lambda - 510.0) / (580.0 - 510.0);
        g = 1.0;
    } else if (lambda >= 580.0 && lambda <= 645.0) {
        r = 1.0;
        g = -1.0 * (lambda - 645.0) / (645.0 - 580.0);
    } else if (lambda >= 645.0 && lambda <= 780.0) {
        r = 1.0;
    }

    double s = 1.0;
    if (lambda > 700.0)
        s = 0.3 + 0.7 * (780.0 - lambda) / (780.0 - 700.0);
    else if (lambda <  420.0)
        s = 0.3 + 0.7 * (lambda - 380.0) / (420.0 - 380.0);

    r = pow(r * s, 0.8)*255;
    g = pow(g * s, 0.8)*255;
    b = pow(b * s, 0.8)*255;
    return qRgb(int(r), int(g), int(b));
}


/*! Returns the color of the light spectrum corresponding to the floating point position pos, in the range [0:1].
*/
uint rainbow(double pos)
{
    if (pos<0)
        return 0;
    else
        return rgbFromWaveLength(380.0 + (pos * 400.0));
}


/*! Returns the color of the light spectrum corresponding to the integer position pos, in the range [0:range].
*/
uint rainbow(int pos, int range)
{
    if (pos<0)
        return 0;
    else
        return rgbFromWaveLength(380.0 + (static_cast<double>(pos)/range * 400.0));
}

