#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QAbstractTransition>
#include <QGraphicsView>
#include <QGraphicsWidget>
#include <QMainWindow>
#include <QParallelAnimationGroup>
#include <QPixmap>
#include <QStateMachine>
#include "fractalPixmap.h"
#include "settingsDialog.h"


class View : public QGraphicsView
{
    Q_OBJECT
public:
    View(QGraphicsScene *scene) : QGraphicsView(scene) { }
signals:
    void resized();
protected:
    void resizeEvent(QResizeEvent *event);
};


class Button : public QGraphicsWidget
{
    Q_OBJECT
public:
    Button(const QPixmap &pixmap, const int buttonSize, int index=-1, QGraphicsItem *parent = 0);
    QRectF boundingRect() const;
    QPainterPath shape() const;
    void paint(QPainter *painter, const QStyleOptionGraphicsItem *option, QWidget *);

signals:
    void pressed(int index, bool doShowDialog);
    void hoverEnter(int index=-1);
    void hoverLeave();

protected:
    void mousePressEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void mouseReleaseEvent(QGraphicsSceneMouseEvent *mouseEvent);
    void hoverEnterEvent(QGraphicsSceneHoverEvent *);
    void hoverLeaveEvent(QGraphicsSceneHoverEvent *);

private:
    QPixmap _pix;
    int fractalTypeIndex;
    int size;
};


class MainWindow : public QMainWindow
{
    Q_OBJECT

public:
    MainWindow(QWidget *parent = 0);
//    CFractalMap fractalMap;
//    CFractalImage fractalImage;

public slots:
    void setProgressRange(const int minimum, const int maximum);
    void setProgressValue(const int value);
    void start();
    void newFrac(const int typeIndex, const bool doShowDialog);
    void redrawGUI();
    void repositionFractals();
    void fractalClicked(int fractIndex);
    void showHint(int index);
    void hideHint();

private slots:

private:
    QAbstractTransition *trans;
    QGraphicsScene scene;
    QGraphicsItem *buttonParent;
    QList<CFractalPixmap *> fractalList;
//    QList<CFractalMap *> fractalList;
    QParallelAnimationGroup *animGroup;

    QList<QState *> stateList;
    QState *rootState;
    QState *initialState;
    QStateMachine states;

    QTimer timer;
    //QLineF bottomLine;
    QGraphicsLineItem *bottomLine;
    QPixmap hintPix;
    QGraphicsPixmapItem *hintItem;
    QGraphicsTextItem *hintText;
    int currentFractal;

    Button *newFractalButtons[FRACTAL_TYPE_COUNT];
    View *view;
};

#endif
