#ifndef SETTINGSDIALOG_H
#define SETTINGSDIALOG_H

#include <QDialog>
#include <QtGui>

enum {
    COLORMAP_SIZE   = 1000,
    PREVIEW_SIZE    = 100,
    ICON_SIZE       = 50,
    DEFAULT_WIDTH   = 1024,
    DEFAULT_HEIGHT  = 768,
    DEFAULT_SUBSTEP = 4,
    DEFAULT_ITERMAX = 1000
};

enum EFractalType{
    MANDELBROT,
    BUDDHABROT,
    JULIA,
    CLIFFORD,
    NOVA,
    CRAB,
    NEWTON,
    BURNINGSHIP,
    TRICORN,
    FRACTAL_TYPE_COUNT
};

struct FractalSettings
{
    EFractalType fractalType;
    int width;
    int height;
    int subStepX;
    int subStepY;
    QPointF center;
    QRectF range;
    double stepBetweenPoints;
    int maxIterations;
    int repeatAll;
};

const int    PRECISION_DIGITS = 9;
const double PRECISION	    = pow(10, -PRECISION_DIGITS);
const double DEFAULT_RIGHT  = 2.0;
const double DEFAULT_LEFT   = -DEFAULT_RIGHT;
const double DEFAULT_STEP   = (DEFAULT_RIGHT-DEFAULT_LEFT)/DEFAULT_WIDTH;
const double DEFAULT_TOP    = DEFAULT_STEP*DEFAULT_HEIGHT/2;
const double DEFAULT_BOTTOM = -DEFAULT_TOP;
const QPointF DEFAULT_CENTER= QPointF(0,0);
const QRectF DEFAULT_RANGE  = QRectF(QPointF(DEFAULT_LEFT, DEFAULT_TOP),
                                     QPointF(DEFAULT_RIGHT, DEFAULT_BOTTOM));

const FractalSettings defaultSettings[FRACTAL_TYPE_COUNT]=
{
    {MANDELBROT,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
        DEFAULT_SUBSTEP,
        DEFAULT_SUBSTEP,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
    {BUDDHABROT,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
	16,
	16,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	500,
	10},
    {JULIA,
	DEFAULT_WIDTH,
	DEFAULT_HEIGHT,
	DEFAULT_SUBSTEP,
	DEFAULT_SUBSTEP,
	DEFAULT_CENTER,
	DEFAULT_RANGE,
	DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
    {CLIFFORD,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
        DEFAULT_SUBSTEP,
        DEFAULT_SUBSTEP,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
    {NOVA,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
        DEFAULT_SUBSTEP,
        DEFAULT_SUBSTEP,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
    {CRAB,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
        DEFAULT_SUBSTEP,
        DEFAULT_SUBSTEP,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
    {NEWTON,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
        DEFAULT_SUBSTEP,
        DEFAULT_SUBSTEP,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
    {BURNINGSHIP,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
        DEFAULT_SUBSTEP,
        DEFAULT_SUBSTEP,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
    {TRICORN,
        DEFAULT_WIDTH,
        DEFAULT_HEIGHT,
        DEFAULT_SUBSTEP,
        DEFAULT_SUBSTEP,
        DEFAULT_CENTER,
        DEFAULT_RANGE,
        DEFAULT_STEP,
	DEFAULT_ITERMAX,
	1},
};


QT_BEGIN_NAMESPACE
//class QCheckBox;
//class QLineEdit;
//class QPushButton;
class QtGui;
QT_END_NAMESPACE


class CSettings : public QDialog
{
    Q_OBJECT

public:
    CSettings(FractalSettings settings=defaultSettings[0], QWidget *parent=0);
    static const char *typeStrings[FRACTAL_TYPE_COUNT];
    static const char *iconFileNames[FRACTAL_TYPE_COUNT];
    static const char *bgFileName;
    FractalSettings getSettings();

signals:
    void launchNewFractal(const FractalSettings settings);

private slots:
    void showSettingsForType(int fracType);
    void xStartChanged(double value) {xStopSpin ->setMinimum(value+PRECISION);}
    void xStopChanged (double value) {xStartSpin->setMaximum(value+PRECISION);}
    void yStartChanged(double value) {yStopSpin ->setMinimum(value+PRECISION);}
    void yStopChanged (double value) {yStartSpin->setMaximum(value+PRECISION);}
    void accept();
    void cancel();

private:
    FractalSettings dialogSettings, initialSettings;
    void setSettings(FractalSettings newSettings);
    // CSettings' Casting, in the order of appearance on screen...(Casting as in a movie, not as in C++ ;-)...
    QComboBox	    *typeCombo;

    QDoubleSpinBox  *xStartSpin;
    QDoubleSpinBox  *xStopSpin;
    QDoubleSpinBox  *yStartSpin;
    QDoubleSpinBox  *yStopSpin;

    QSpinBox	    *widthSpin;
    QSpinBox	    *heightSpin;

    QSpinBox	    *iterSpin;

    QDialogButtonBox *dialogButtons;
};

#endif // SETTINGSDIALOG_H
