/*
# Copyright (c) 2010 Louis du Verdier
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "MainWindow.h"

/*!
 * \file GraphicsWidgets.cpp
 * \brief Rassemble les fonctions des classes GraphicsScene et GraphicsView.
 * \author Louis du Verdier
 * \version 1.0
 */

GraphicsScene::GraphicsScene(MainWindow *p)
{
	parent = p;
}

void GraphicsScene::changeSceneBgColor(QImage set)
{
	if(parent->resized)
	{
		QMessageBox::information(parent, "Fractales", "La scne a t redimensionne.<br />Vous devez regnrer la scne "
			"pour que l'outil de coloration intelligente fonctionne correctement.");
		return;
	}
	QColor left_color = set.pixel(QPoint(1, set.height() / 3));
	QColor right_color = set.pixel(QPoint(set.width() - 1, set.height() / 3));
	if(!left_color.isValid() || !right_color.isValid()) return;
	setBackgroundBrush(QBrush(left_color));
	QGraphicsItem *item = addRect(QRect(QPoint(sceneRect().bottom(), sceneRect().top()),
		QSize(sceneRect().width() / 2, sceneRect().height())),
		QPen(right_color), QBrush(right_color));
	item->setZValue(-1);
}

void GraphicsScene::showMandelbrot(QImage mandelbrot)
{
	renderItem = addPixmap(QPixmap::fromImage(mandelbrot));
	renderItem->setPos(0 - mandelbrot.width() / 2, 0 - mandelbrot.height() / 2);

	if(parent->intelColo->isChecked())
	changeSceneBgColor(mandelbrot);
}

void GraphicsScene::mouseMoveEvent(QGraphicsSceneMouseEvent *event)
{
	if(!parent) return;
	parent->positionArea->setText(tr("Position : ") +
		QString::number(event->scenePos().x()) + ", " +
		QString::number(event->scenePos().y()) + " ");
}

GraphicsView::GraphicsView(MainWindow *p)
{
	parent = p;
}

void GraphicsView::enterEvent(QEvent *)
{
	emit mouseEnter();
}

void GraphicsView::leaveEvent(QEvent *)
{
	emit mouseLeave();
	GraphicsScene *graphicsScene = qobject_cast<GraphicsScene *>(scene());
	if(graphicsScene) graphicsScene->parent->positionArea->clear();
}

void GraphicsView::contextMenuEvent(QContextMenuEvent *)
{
	if(parent->generation) return;

	QMenu contextMenu;
	contextMenu.addSeparator();

	contextMenu.addAction(tr("Enregistrer la scne"), parent, SLOT(saveScene()));
	contextMenu.addAction(tr("Nettoyer la scne"), parent->scene, SLOT(clear()));
	contextMenu.exec(cursor().pos());
}

