/*
# Copyright (c) 2010 Louis du Verdier
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "MainWindow.h"

/*!
 * \file ToolsArea.cpp
 * \brief Rassemble les fonctions de la classe ToolsArea.
 * \author Louis du Verdier
 * \version 1.0
 */

ToolsArea::ToolsArea(MainWindow *p)
{
	parent = p;
	effect = new QGraphicsColorizeEffect;
	_effect = new QGraphicsColorizeEffect;
}

void ToolsArea::setEffect()
{
	if(isFloating() || isHidden()) return;
	delete effect;

	effect = new QGraphicsColorizeEffect;
	effect->setColor(QColor("#555555"));
	setGraphicsEffect(effect);

	if(!parent) return;
	delete _effect;

	_effect = new QGraphicsColorizeEffect;
	_effect->setColor(QColor("#555555"));
	parent->statusBar()->setGraphicsEffect(_effect);
}

void ToolsArea::unsetEffect()
{
	setGraphicsEffect(NULL);

	if(parent)
	parent->statusBar()->setGraphicsEffect(NULL);
}
