/* Copyright (c) 2010(Hennequin Thibault) Permission is hereby granted, free of charge,
to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy,
modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. */

#ifndef BROTDISPLAY_H
#define BROTDISPLAY_H

#include <QWidget>
#include <QtOpenGL>
#include <QTimer>

#include "fractal.h"
#include "renderthread.h"

/** Widget d'affichage des fractales **/
class BrotDisplay : public  QGLWidget
{
	Q_OBJECT
public:
	BrotDisplay( QWidget *parent = 0 );
	~BrotDisplay();

	/* Dfinition du nombre de thread utilis pour le rendu software */
	void SetupThread(int count);

	/* Annule le rendu en cours */
	void Cancel();

	/* Sauve le rendu dans un fichier image */
	bool Save(QString file);
	public slots:
		void SetPosX( double x );
		void SetPosY( double y );
		void SetZoom( double z );
		void SetIteration( int ite );
		void SetFractal( Fractal frac );
		void SetThreadCount( int count );
		void SetPrecision( double precision );
		void SetMinIteration( int min );
		void SetReal( double real );
		void SetImaginary( double imaginary );
		void SetSmoothColors( bool smooth );
		void SetAnimatedRender( bool animated );

		void SetGradient( const QGradientStops& stops );
		void SetDilatation( double dilatation );

		void OnThreadFinish(int id);
		void OnThreadProgress(float, int);

		/* Initialise le rendu */
		void RedrawFractal();

		void OnTimer();
signals:
		void ZoomChanged( double );
		void PosXChanged( double );
		void PosYChanged( double );
		void IterationChanged( int );
		void ThreadCountChanged( int );
		void PrecisionChanged( double );
		void RealChanged( double );
		void ImaginaryChanged( double );
		void SmoothColorsChanged( bool );
		void AnimatedRenderChanged( bool );
		void DilatationChanged( double );

		void Progress( float );
protected:
	void wheelEvent( QWheelEvent *event );
	void mousePressEvent( QMouseEvent *event );
	void mouseReleaseEvent( QMouseEvent *event );
	void mouseMoveEvent( QMouseEvent *event );

	virtual void paintEvent( QPaintEvent *event );
	virtual void resizeEvent( QResizeEvent *event );

	virtual void initializeGL();
	virtual void paintGL();
	virtual void resizeGL( int width, int height );

	/** Charge un fichier texte dans les ressources **/
	QString LoadResTxt( const char *file );

	/** Gnre la texture du gradient **/
	void GenerateTexture();
protected:
	Fractal		m_iFractal;
	QImage		m_Image;
	QMutex		m_ImageMutex;

	QTimer		m_Timer;
	QTime		m_iLastPaint;

	/* Animation du zoom */
	double		m_fCurrentZoom;
	int			m_iZoomCount;	

	double		m_fRenderPosX;
	double		m_fRenderPosY;
	double		m_fRenderZoom;

	bool		m_bDrag;
	QPoint		m_MousePoint;
	double		m_fOrigX;
	double		m_fOrigY;
	bool		m_bWaitRender;

	QImage		m_GradientImage;
	QImage		m_TempGradientImage;
	/** Software (thread) resources **/
	QList<RenderThread*>	m_RenderThreads;
	QVector<float>		m_RenderProgress;
	int				m_iRenderFinishCount;

	/** OpenGL resources **/
	/** Si la version de QT est infrieur  la 4.6 alors on n'utilise pas OpenGL **/
#if QT_VERSION >= 0x040600
	QGLShader*		m_pVertexShader;
	QGLShader*		m_pFragmentShader[2];
	QGLShaderProgram*	m_pShader[2];
#endif
	GLuint			m_iTexture;

	float		m_fRatio;
	double		m_fPosX;
	double		m_fPosY;
	double		m_fZoom;
	int			m_iIteration;
	double		m_fPrecision;
	int			m_iMinIteration;
	double		m_fReal;
	double		m_fImaginary;
	double		m_fDilatation;

	QGradientStops	m_Gradient;
	bool			m_bSmoothColors;
	bool			m_bAnimatedRender;
};

#endif // BROTDISPLAY_H
