/* Copyright (c) 2010(Hennequin Thibault) Permission is hereby granted, free of charge,
to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy,
modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. */

#ifndef GRADIENTS_H
#define GRADIENTS_H

#include "hoverpoints.h"

#include <QtGui>

class HoverPoints;

class ShadeWidget : public QWidget
{
	Q_OBJECT
public:
	enum ShadeType {
		RedShade,
		GreenShade,
		BlueShade,
		RGBShade
	};

	ShadeWidget(ShadeType type, QWidget *parent);

	void setGradientStops(const QGradientStops &stops);
	void setPointsFromGradientStops(const QGradientStops &stops);

	void paintEvent(QPaintEvent *e);

	QSize sizeHint() const { return QSize(250, 60); }
	QPolygonF points() const;

	HoverPoints *hoverPoints() const { return m_hoverPoints; }

	uint colorAt(int x);

signals:
	void colorsChanged();

private:
	void generateShade();

	ShadeType m_shade_type;
	QImage m_shade;
	HoverPoints *m_hoverPoints;
	QLinearGradient m_alpha_gradient;
};

#endif
