/* Copyright (c) 2010(Hennequin Thibault) Permission is hereby granted, free of charge,
to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy,
modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. */

#ifndef MAINWINDOW_H
#define MAINWINDOW_H

#include <QMainWindow>
#include <QtGui/QHBoxLayout>
#include <QtGui/QToolBox>
#include <QtGui/QMenuBar>
#include <QtGui/QMenu>
#include <QtGui/QStatusBar>
#include <QtGui/QProgressBar>
#include <QtGui/QPushButton>

#include "brotdisplay.h"
#include "gradient.h"

namespace Ui {
	class MainWindow;
}

/** Fenettre principale du programme **/
class MainWindow : public QMainWindow
{
	Q_OBJECT
public:
	MainWindow(QWidget *parent = 0);
	~MainWindow();
	public slots:
		void OnProgress( float );
		void TranslateUI();
		void SetFractal(int fractal);
		void SetRenderWidth(int width);
		void SetRenderHeight(int height);
		void SetAnimatedRender(int animated);
		void SetSmoothColors(int smooth);

		void Cancel(bool);

		void SaveImage(void);

		void colorsChanged(void);

		void LanguageChanged(int);
		void LanguageFrench();
		void LanguageEnglish();
protected:
	void changeEvent(QEvent *e);

private:
	QTranslator		m_Translator;
	QHBoxLayout*    m_pMainLayout;
	QToolBox*       m_pToolBox;
	QWidget*		m_pParametersBox;
	QFormLayout*	m_pParametersLayout;
	QLabel*			m_pZoomLabel;
	QDoubleSpinBox* m_pZoomSpin;
	QLabel*			m_pPosXLabel;
	QDoubleSpinBox* m_pPosXSpin;
	QLabel*			m_pPosYLabel;
	QDoubleSpinBox* m_pPosYSpin;
	QLabel*			m_pIterationLabel;
	QSpinBox*	    m_pIterationSpin;
	QLabel*			m_pFractalLabel;
	QComboBox*	    m_pFractalComboBox;

	QWidget*	    m_pBuddhaBrotParameters;
	QFormLayout*    m_pBuddhaBrotParametersLayout;
	QLabel*			m_pPrecisionLabel;
	QDoubleSpinBox* m_pPrecisionSpin;
	QLabel*			m_pMinIterationLabel;
	QSpinBox*		m_pMinIterationSpin;

	QWidget*	    m_pJuliaParameters;
	QFormLayout*    m_pJuliaParametersLayout;
	QLabel*			m_pRealLabel;
	QDoubleSpinBox* m_pRealSpin;
	QLabel*			m_pImagLabel;
	QDoubleSpinBox* m_pImagSpin;

	QWidget*	m_pColorsBox;
	QFormLayout*	m_pColorsLayout;
	ShadeWidget*    m_pRedShade;
	ShadeWidget*    m_pGreenShade;
	ShadeWidget*    m_pBlueShade;
	ShadeWidget*    m_pRGBShade;
	QLabel*			m_pDilatationLabel;
	QDoubleSpinBox* m_pDilatationSpin;

	QWidget*	m_pRenderBox;
	QFormLayout*	m_pRendersLayout;
	QLabel*	    m_pThreadCountLabel;
	QSpinBox*	m_pThreadCountSpin;
	QLabel*	    m_pWidthLabel;
	QSpinBox*	m_pWidthSpin;
	QLabel*	    m_pHeightLabel;
	QSpinBox*	m_pHeightSpin;
	QLabel*		m_pSmoothLabel;
	QCheckBox*	m_pSmoothCheckBox;
	QLabel*		m_pAnimatedLabel;
	QCheckBox*	m_pAnimatedCheckBox;

	QScrollArea*    m_pDisplayScroll;
	BrotDisplay*    m_pDisplay;

	QMenuBar*	    m_pMenuBar;
	QMenu*	    m_pMenuFile;
	QAction*	m_pActionSave;
	QAction*	m_pActionExit;
	QMenu*	    m_pMenuOptions;
	QMenu*		m_pMenuLanguage;
	QAction*	m_pActionLanguageFrench;
	QAction*	m_pActionLanguageEnglish;
	QAction*	m_pActionAbout;

	QPushButton*	m_pRenderButton;
	QProgressBar*   m_pProgressBar;
	QLabel*			m_pProgressLabel;
	QPushButton*	m_pCancelButton;

	QGradientStops	m_Gradient;
};

#endif // MAINWINDOW_H
