/* Copyright (c) 2010(Hennequin Thibault) Permission is hereby granted, free of charge,
to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy,
modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. */

#ifndef RENDERTHREAD_H
#define RENDERTHREAD_H

#include <QtGui>
#include <QMutex>
#include <QSize>
#include <QThread>
#include <QWaitCondition>
#include <QImage>

#include "fractal.h"


/** Thread de rendu des fractales **/
class RenderThread : public QThread
{
	Q_OBJECT

public:
	RenderThread(QObject *parent = 0, int id = 0);
	~RenderThread();

	/* Dfinie les paramtre de dessin du fractale */
	void SetRender(int w, int h,
		int threadCount,
		double centerx, double centery,
		double precision, int minIteration,
		double real, double imaginary,
		double zoom, int iteration, Fractal fractal,
		const QGradientStops& gradient, QImage *gradientImage, bool smooth, float dilatation,
		QImage *image, QMutex *imageMutex);
	/* Arrte le rendu */
	void Stop();
	/* Arrte le thread */
	void Finish();
protected:
	void run();

	/* Fonctions des diffrents rendu */
	void RenderMandelBrot();
	void RenderBuddhabrot();
	void RenderJulia();
signals:
	void Progress(float pourcent, int threadId);
	void Finish(int threadId);
protected:
	QMutex m_Mutex;
	QWaitCondition m_Condition;

	/* BuddhaBrot shared memory*/
	static QVector<unsigned long> m_Map;
	static int m_iThreadFinish;
	static unsigned long m_iMax;

	int m_iId;

	bool m_bRestart;
	bool m_bStop;
	bool m_bFinish;

	Fractal m_iFractal;
	int m_iThreadCount;
	int m_iProgress;
	int m_iX;
	int m_iY;
	int m_iW;
	int m_iH;
	int m_iRW;
	int m_iRH;
	double m_fCenterX;
	double m_fCenterY;
	double m_fZoom;
	double m_fPrecision;
	int m_iMinIteration;
	int m_iIteration;
	double m_fReal;
	double m_fImaginary;
	bool m_bSmoothColors;
	float m_fDilatation;
	QImage *m_pImage;
	QMutex *m_pImageMutex;

	QGradientStops m_Gradient;
	QImage *m_pGradientImage;
};

#endif
