/* Copyright (c) 2010(Hennequin Thibault) Permission is hereby granted, free of charge,
to any person obtaining a copy of this software and associated documentation files (the "Software"),
to deal in the Software without restriction, including without limitation the rights to use, copy,
modify, merge, publish, distribute, sublicense, and/or sell copies of the Software,
and to permit persons to whom the Software is furnished to do so, subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.
THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED,
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE. */

uniform sampler2D texture;
varying vec4 texc;
uniform int width;
uniform int height;
uniform float zoom;
uniform float posx;
uniform float posy;
uniform int max_iter;
uniform float real;
uniform float imag;
uniform int smoothcolors;
uniform float dilatation;

void main(void)
{
    float ratio = float(width)/height;
	float newWidth = ratio*512.0;
	float newHeight = 512.0;
	float x0b;
	float y0b;
	
    float x0 = texc.x;
    float y0 = texc.y;
	x0b = ratio*512.0*x0/width;
	y0b = 512.0*y0/height;
    int iter = 0;
	float x = (x0b-newWidth/2.0)*zoom+posx;
	float y = (y0b-newHeight/2.0)*zoom+posy;
    float xtemp;
    while (x*x + y*y <= (2*2) && iter < max_iter)
    {
		xtemp = x*x - y*y + real;
		y = 2*x*y + imag;
		x = xtemp;
		iter++;
    }

    if ( iter == max_iter )
    {
		gl_FragColor = vec4(0,0,0,1);
    }else{
		float val = iter;
		if (smoothcolors==1)
		{
			val = val-log2(log2(sqrt(x*x+y*y)));
		}
		val = (sin(val/dilatation)+1.0)*0.5;
		gl_FragColor = texture2D(texture,vec2(val,val));
    }
}
