/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "CCurve.hpp"

#include "../Fractale/Commun.hpp"
#include "../Fractale/Image.hpp"
#include "../Fractale/GFractale.hpp"
#include "../Fractale/Generateur.hpp"

#include <QObject>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

CCurve :: CCurve( ParamsCurve params,
						QObject* parent /*= 0*/)
	:QThread(parent),
	params(params)
{	
#ifndef QT_NO_DEBUG
	std::cout << "CCurve (thread) created" << std::endl;

	std::cout << "Generator: " << params.lcfct << std::endl;
	
	std::cout << "Image(" << params.iWidth << ";" << params.iHeight << ")" << std::endl;
	std::cout << "Zone(" << params.zX << ";" << params.zY << ";" << params.zWidth << ";" << params.zHeight << ")" << std::endl << std::endl;
#endif
}

CCurve :: ~CCurve(void)
{
#ifndef QT_NO_DEBUG
	std::cout << "CFractale (thread) deleted" << std::endl;
#endif	
}
		
void CCurve :: run(void)
{
	Fractale::CliffordAttractors* curveFCT = NULL;
	
	switch ( params.lcfct )
	{
		case lcfctCLIFFORDATTRACTORS:
		{
			curveFCT = new Fractale::CliffordAttractors(params.paramA, params.paramB, params.paramC, params.paramD);
		}break;
		
		case lcfctCLIFFORDATTRACTORS2:
		{
			curveFCT = new Fractale::CliffordAttractors(params.paramA, params.paramB, params.paramC, params.paramD);
		}break;
		
		case lcfctENDOFLIST:
		{
#ifndef QT_NO_DEBUG
			std::cout << "Problem with the identifier of the fractale function (lcfctENDOFLIST) " << std::endl;
#endif
			delete curveFCT;
			return;
		}break;
	}
	
	fractale = Fractale::TracerCourbe(*curveFCT, params.nbPoints, Fractale::point(params.pX, params.pY), Fractale::Zone(params.zX,params.zY,params.zHeight,params.zWidth, params.iHeight, params.iWidth));
	
	delete curveFCT;
}
