/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "CFractale.hpp"

#include "../Fractale/Commun.hpp"
#include "../Fractale/Image.hpp"
#include "../Fractale/GPointInitialisation.hpp"
#include "../Fractale/GFractale.hpp"
#include "../Fractale/GAccumulateur.hpp"
#include "../Fractale/Generateur.hpp"

#include <QObject>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

CFractale :: CFractale( Params params,
						QObject* parent /*= 0*/)
	:QThread(parent),
	params(params)
{
	//this->setTerminationEnabled(true);	
	
#ifndef QT_NO_DEBUG
	std::cout << "CFractale (thread) created" << std::endl;

	std::cout << "Initializor: " << params.lifct << std::endl;
	std::cout << "Generator: " << params.lgfct << std::endl;
	std::cout << "Accumulator: " << params.lafct << std::endl << std::endl;
	
	std::cout << "Image(" << params.iWidth << ";" << params.iHeight << ")" << std::endl;
	std::cout << "Zone(" << params.zX << ";" << params.zY << ";" << params.zWidth << ";" << params.zHeight << ")" << std::endl << std::endl;
#endif
}

CFractale :: ~CFractale(void)
{
#ifndef QT_NO_DEBUG
	std::cout << "CFractale (thread) deleted" << std::endl;
#endif	
}
		
void CFractale :: run(void)
{
	Fractale::GPointInitialisation* initFCT = NULL;
	Fractale::GFractale* fractaleFCT = NULL;
	Fractale::GAccumulateur* accumulatorFCT = NULL;
	
	switch ( params.lifct )
	{
		case lifctPOINTALEATOIRE:
		{
			initFCT = new Fractale::PointAleatoire();
		}break;
		
		case lifctPOINTIMAGE:
		{
			initFCT = new Fractale::PointImage();
		}break;
		
		case lifctENDOFLIST:
		{
#ifndef QT_NO_DEBUG
			std::cout << "Problem with the identifier of the initializor function (lifctENDOFLIST)" << std::endl;
#endif
			return;
		}break;
	}
	
	switch ( params.lgfct )
	{
		case lgfctMANDELBROT:
		{
			fractaleFCT = new Fractale::Mandelbrot();
		}break;
		
		case lgfctBATEAUENFEU:
		{
			fractaleFCT = new Fractale::BateauEnFeu();
		}break;
		
		case lgfctTRICORN:
		{
			fractaleFCT = new Fractale::Tricorn();
		}break;
		
		case lgfctJULIAN:
		{
			fractaleFCT = new Fractale::Julian();
		}break;
		
		case lgfctNEWTON:
		{
			fractaleFCT = new Fractale::Newton();
		}break;
		
		case lgfctNOVA:
		{
			fractaleFCT = new Fractale::Nova();
		}break;
		
		case lgfctENDOFLIST:
		{
#ifndef QT_NO_DEBUG
			std::cout << "Problem with the identifier of the fractale function (lifctENDOFLIST) " << std::endl;
#endif
			delete initFCT;
			return;
		}break;
	}
	
	switch ( params.lafct )
	{
		case lafctACCUMULERSURLASEQUENCE:
		{
			accumulatorFCT = new Fractale::AccumulerSurLaSequence();
		}break;
		
		case lafctACCUMULERSURORIGINE:
		{
			accumulatorFCT = new Fractale::AccumulerSurOrigine();
		}break;
		
		case lafctENDOFLIST:
		{
#ifndef QT_NO_DEBUG
			std::cout << "Problem with the identifier of the accumulation function (lifctENDOFLIST) " << std::endl;
#endif
			delete initFCT;
			delete fractaleFCT;
			return;
		}break;
	}
	
	fractale = Fractale::Generateur(initFCT, fractaleFCT, accumulatorFCT, Fractale::Zone(params.zX,params.zY,params.zHeight,params.zWidth, params.iHeight, params.iWidth));
	
	delete accumulatorFCT;
	delete fractaleFCT;
	delete initFCT;
}
