#ifndef __CFRACTALE_HPP__
#define __CFRACTALE_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QThread>

#include "../Fractale/Image.hpp"

#include "../global.hpp"

class QObject;

namespace Fractale
{
	class GPointInitialisation;
	class GFractale;
	class GAccumulateur;
};

/*! \class CFractale
 *  \brief Classe appelant la méthode de Yan pour le dessin des fractales.\n
 *  Cette classe est un thread ( héritage de QThread )\n
 *  Elle générera la fractale.
 */
class CFractale : public QThread
{
	private:
	
		Params params; /*!< Paramètre à donner à la fonction de génération de courbe de Yan */
		
		Fractale::Image<unsigned int> fractale; /*!< Image resultat de la fonction de dessin des fractales */
	
	public:
	
		/*!
		 *  \brief Constructeur
		 *  \param params : Les paramètre pour la génération
		 *  \param parent : Le QObject parent.
		 */
		CFractale(	const Params params,
					QObject* parent = 0);
		/*!
		 *  \brief Destructeur
		 */
		~CFractale(void);
		
		/*!
		 *  \brief Surcharge la méthode run de la classe QThread. Cette fonction est la fonction threadé.
		 */
		void run(void);
		
		/*!
		 *  \brief Getteur pour l'image générée.
		 *  \return Un vector de pixel représentant l'image
		 */
		Fractale::Image<unsigned int>* getFractale(void) { return &fractale; };
};

#endif
