#ifndef __CURVE_HPP__
#define __CURVE_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QThread>

#include <QVector>
#include <QColor>

#include "../global.hpp"

class QObject;
class QString;
class QImage;

class ProgressDialog;

/*! \class Curve
 * \brief Surcharge du QThread afin d'avoir une thread faisant la generation de la fractale.\n
 * Ceci est un thread pour ne pas bloquer l'interface.
 */
class Curve : public QThread
{
	Q_OBJECT
	
	private:
	
		ProgressDialog* pd;		/*!< Dialogue de progression */
	
		ParamsCurve params;		/*!< Paramètre de génération */
		QVector<QRgb> table;	/*!< Table des couleurs pour l'image */
		
		unsigned char* pFractale;	/*!< Tableau de pixel pour la fractale */
		QString* pTitle;			/*!< Titre que l'on devra mettre pour cet fenêtre ( dialogue de progression ) */
		
	public:
	
		/*!
		 *  \brief Constructeur
		 *  \param params : Les paramètre pour la génération.
		 *  \param params : La table de couleur.
		 *  \param params : La fenêtre parente.
		 *  \param parent : Le QObject parent.
		 */
		Curve(const ParamsCurve params, QVector<QRgb> table, QWidget* parentWin,
					QObject* parent = 0);
		/*!
		 *  \brief Destructeur
		 */
		~Curve(void);
		
		/*!
		 *  \brief Surcharge la méthode run de la classe QThread. Cette fonction est la fonction threadé.
		 */
		void run(void);
		
		/*!
		 *  \brief Getteur pour l'image générée.
		 *  \return Un tableau de pixel représentant l'image
		 */
		unsigned char* getFractale(void)const { return pFractale; };
		
		/*!
		 *  \brief Getteur pour le titre de la génération.
		 *  \return Le titre
		 */
		QString getTitle(void)const;
		
		/*!
		 *  \brief Getteur pour les paramètres de la génération. ( La classe sert comme stockage )
		 *  \return Les paramètres de la génération.
		 */
		ParamsCurve getParams(void)const { return params; };
		
		/*!
		 *  \brief Getteur pour la table des couleurs.
		 *  \return La table des couleurs à utiliser.
		 */
		const QVector<QRgb> getTable(void)const { return table; }
};

#endif
