/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "Generation.hpp"

#include "CFractale.hpp"

#include "../Interface/ProgressDialog.hpp"

#include "../Fractale/Image.hpp"
#include "../Fractale/GPointInitialisation.hpp"
#include "../Fractale/GFractale.hpp"
#include "../Fractale/GAccumulateur.hpp"

#include "../global.hpp"

#include <QObject>

#include <QImage>
#include <QString>

#include <limits>
#include <algorithm>
#include <fstream>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

extern short unsigned int nbCore;

#ifdef _CALLBACK_QT
	extern ProgressFeedBack pf;
#endif

Generation :: Generation(const Params params, const QVector<QRgb> table, QWidget* parentWin,
						 QObject* parent /*= 0*/)
	:QThread(parent),
	params(params),
	table(table)
{
	pFractale = new unsigned char[params.iWidth * params.iHeight];
	
		// Petite analyse pour mettre un titre logique à l'onglet
	switch ( params.lgfct )
	{
		case lgfctMANDELBROT:
		{
			pTitle = new QString(tr("Mandelbrot"));
		}break;
		
		case lgfctBATEAUENFEU:
		{
			pTitle = new QString(tr("Fire boat"));
		}break;
		
		case lgfctTRICORN:
		{
			pTitle = new QString(tr("Tricorn"));
		}break;
		
		case lgfctJULIAN:
		{
			pTitle = new QString(tr("Julian"));
		}break;
		
		case lgfctNEWTON:
		{
			pTitle = new QString(tr("Newton"));
		}break;
		
		case lgfctNOVA:
		{
			pTitle = new QString(tr("Nova"));
		}break;
		
		case lgfctENDOFLIST:
		{
#ifndef QT_NO_DEBUG
			std::cout << "Problem with the identifier of the fractale function (lifctENDOFLIST) " << std::endl;
#endif
			pTitle = new QString(tr("Unknown"));
		}break;
	}

	//this->setTerminationEnabled(true);	
	pd = new ProgressDialog(*pTitle,parentWin);
	//connect(pd, SIGNAL(canceled()), this, SLOT(terminate()));
#ifdef _CALLBACK_QT
	connect(&pf, SIGNAL(sendNewValue(int)), pd, SLOT(progressValue(int)));
#endif
	pd->show();

#ifndef QT_NO_DEBUG
	std::cout << "Generation (thread) created" << std::endl;
#endif
}

Generation :: ~Generation(void)
{
	// Peut être pas très utile vu que l'objet va être détruit
	disconnect(pd, SIGNAL(canceled()), this, SLOT(terminate()));
	delete pd;
	
	delete pFractale;
	delete pTitle;

#ifndef QT_NO_DEBUG
	std::cout << "Generation (thread) deleted" << std::endl;
#endif	
}

void Generation :: run(void)
{	
#ifndef QT_NO_DEBUG
	std::cout << "Generation (thread) started" << std::endl;
#endif
	
	// Generation à proprement parler
	// Et remplissage du QImage
	{
		QVector<CFractale*> fthreads;

		// Generation
		{			
			Params threadsParams = params;
			
			// Découpage des paramètres pour les différents threads
			threadsParams.iHeight = threadsParams.iHeight / nbCore;	// La taille de l'image rendue est coupé
			threadsParams.zHeight = threadsParams.zHeight / nbCore; // La zone à rendre est coupé
			
			
			// Démarrage des différents thread ( quand on est sur du multi coeur )
			for ( unsigned int i = 0 ; i < nbCore ; i++ )
			{
				CFractale* newFractale = NULL;
				
				threadsParams.zY = params.zY + (threadsParams.zHeight * i); // Pour chaque threads, nous avons juste à rendre une partie différente	
				
				newFractale = new CFractale(threadsParams);
				
				fthreads.push_back(newFractale);
				newFractale->start();
			}
			
			// Nous attendons les threads
			for ( unsigned int i = 0 ; i < nbCore ; i++ )
			{
				// On peux attendre le thread indéfiniment car nous sommes dans un thread
				while ( !fthreads[i]->isFinished() )
				{
					
				}
			}
		}
		
		unsigned int pixelCounter = 0;
		
		// Reconstitution des images	
		// Pour tout les coeurs
		for ( unsigned int i = 0 ; i < nbCore ; i++ )
		{
			Fractale::Image<unsigned int>* pFractaleIMG = fthreads[i]->getFractale();
			for ( Fractale::Image<unsigned int>::const_iterator it_pixels = pFractaleIMG->begin() ; it_pixels != pFractaleIMG->end() ; ++it_pixels )
			{
				pFractale[pixelCounter++] = *it_pixels;;
			}
			
			// On supprime le CFractale dans la liste
			delete fthreads[i];
		}
	}
}

QString Generation :: getTitle(void)const
{ 
	if ( pTitle )
		return *pTitle; 
	else
		return QString("");
};
