#ifndef __GENERATEUR_HPP__
#define __GENERATEUR_HPP__

/*
# Copyright (c) 2009 Yan Verdavaine
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "Image.hpp"
#include "GPointInitialisation.hpp"
#include "GFractale.hpp"
#include "GAccumulateur.hpp"
/*!
 * \file Generateur.hpp
 * \brief définition de la classe représantant une suite fractale et quelques exemples.
 * \author Yan Verdavaine
 * \version 1.0
 */

namespace Fractale
{
	/**
	 * \brief Génère une image fractale.
	 *
	 * \tparam T doit être un GPointInitialisation.
	 * \tparam T2 doit être un GFractale.
	 * \tparam T3 doit être un GAccumulateur.
	 * \param  zoneImage : zone du plan complexe et taille de l'image voulue.
	 * \return L'image résultante.
	 */
	//template<typename T,typename T2,typename T3>
	Image<unsigned int> Generateur
	(
		GPointInitialisation* initFCT,
		GFractale* fractaleFCT,
		GAccumulateur* accumulateurFCT,
		Zone zoneImage
	);


	/**
	 * \brief Dessine la suite de points d'une suite fractale.
	 *
	 * \tparam T doit être un GFractale. Cette fractale ne doit pas avoir de fin et la suite générée ne doit pas être nulle.
	 * \param nbLoop : nombre d'itération de continuité de la suite fractale.
	 * \param z : point de départ.
	 * \param  zoneImage : zone du plan complexe et taille de l'image voulue.
	 * \return L'image résultante.
	 */
	template<typename T>
	Image<unsigned int> TracerCourbe
	(
		T t,
		unsigned int nbLoop,
		point z,
		Zone zoneImage
	)
	{
		GFractale  &fractale(t);
		AccumulerSurLaSequence accumulateur;

		accumulateur.m_zone             = zoneImage;



		Image<unsigned int> resultat(zoneImage.imgH,zoneImage.imgL);
		for(unsigned int i =0; i <nbLoop;++i)
		{			
#ifdef _CALLBACK_QT
			int pourcentage = (100* i) / nbLoop;

			// Retour d'information pour QT
			retourPourcentage(pourcentage);
#endif

			const std::vector<point> & sequence = fractale.genererSequence(z);
			accumulateur.accumuler(resultat,z,sequence);
			z = fractale.suivant(*sequence.rbegin());
		}
		return resultat;

	}
}

#endif
