/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "ColourDialog.hpp"

#include "FrameColored.hpp"

#include <QGridLayout>
#include <QFrame>
#include <QSpinBox>
#include <QPushButton>
#include <QColorDialog>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif	

ColourDialog :: ColourDialog(const QVector<QRgb>& table, QWidget* parent /* = 0*/)
	:QDialog(parent),
	table(table),
	pMainGrid(NULL),
	pColourBox(NULL),
	pColourSelector(NULL),
	pColourButton(NULL),
	pCancelButton(NULL),
	pApplyButton(NULL),
	pValidateButton(NULL)
{
	pMainGrid = new QGridLayout(this);
	
	pColourBox =  new FrameColored(table[0],this);
	pMainGrid->addWidget(pColourBox, 0, 0);
		
	pColourSelector = new QSpinBox(this);
	pColourSelector->setMaximum(255);
	pColourSelector->setValue(0);
	
	pMainGrid->addWidget(pColourSelector, 0, 1);
	
	connect(pColourSelector, SIGNAL(valueChanged(int)), this, SLOT(changeFrameColour(int)));
		
	pColourButton = new QPushButton(tr("Change"), this);
	
	pMainGrid->addWidget(pColourButton, 0, 2);
	
	pCancelButton = new QPushButton(tr("Cancel"), this);
	
	pMainGrid->addWidget(pCancelButton, 1, 0);
	
	pApplyButton = new QPushButton(tr("Apply"), this);
	
	pMainGrid->addWidget(pApplyButton, 1, 1);
	
	pValidateButton = new QPushButton(tr("Ok"), this);
	
	pMainGrid->addWidget(pValidateButton, 1, 2);
	
	connect(pColourButton, SIGNAL(clicked()), this, SLOT(changeColour()));
	connect(pCancelButton, SIGNAL(clicked()), this, SLOT(cancel()));
	connect(pApplyButton, SIGNAL(clicked()), this, SLOT(apply()));
	connect(pValidateButton, SIGNAL(clicked()), this, SLOT(validate()));
	
	
	// ToDO: Gestion des connections ( boutons )
	// Gestion des couleurs / listes de couleurs
#ifndef QT_NO_DEBUG
	std::cout << "ColourDialog created" << std::endl;
#endif	
}

void ColourDialog :: changeFrameColour(int index)
{
	pColourBox->setColor(table[index]);
	pColourBox->repaint();
}

void ColourDialog :: changeColour(void)
{
	QColor colourSelected = QColorDialog::getColor(table[pColourSelector->value()], this, tr("Select the new colour to use"));
	
	if ( colourSelected.isValid() )
	{
		table[pColourSelector->value()]  = colourSelected.rgb();
		
		// Mis à jour de la boite
		pColourBox->setColor(colourSelected);
		pColourBox->repaint();
	}
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: ColourDialog :: changeColour" << std::endl;
#endif
}

void ColourDialog :: cancel(void)
{
	this->done(1);
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: ColourDialog :: cancel" << std::endl;
#endif
}

void ColourDialog :: apply(void)
{
	emit needsApply(table);
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: ColourDialog :: apply" << std::endl;
#endif
}

void ColourDialog :: validate(void)
{
	this->done(0);
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: ColourDialog :: validate" << std::endl;
#endif
}



ColourDialog :: ~ColourDialog(void)
{
	delete pValidateButton;
	delete pApplyButton;
	delete pCancelButton;
	delete pColourButton;
	
	delete pColourSelector;
	
	delete pColourBox;
	
	delete pMainGrid;
	
#ifndef QT_NO_DEBUG
	std::cout << "ColourDialog deleted" << std::endl;
#endif		
}
