#ifndef __COLOURDIALOG_HPP__
#define __COLOURDIALOG_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QDialog>

class QGridLayout;
class QFrame;
class QSpinBox;
class QPushButton;
class FrameColored;

/*! \class ColourDialog
 * \brief Fenêtre pour la selection de toute les couleurs d'une paelette, mais une par une
 */
class ColourDialog : public QDialog
{
	Q_OBJECT
	
	private:
		QVector<QRgb> table;		/*!< La palette avec laquelle nous jouons */
	
		QGridLayout* pMainGrid;		/*!< Grid pour l'arrangement des elements dans la fenêtre */
		FrameColored* pColourBox;	/*!< Petit afficheur de couleur */
		
		QSpinBox* pColourSelector;	/*!< Permet de changer la couleur */
		
		QPushButton* pColourButton;	/*!< Bouton pour ouvrir le QColourDialog */
		QPushButton* pCancelButton;	/*!< Bouton d'annulation */
		QPushButton* pApplyButton;	/*!< Bouton pour appliquer les changements */
		QPushButton* pValidateButton;	/*!< Bouton pour accepter les changements */
		
	signals:
	
		/*!
		 * \brief Signal pour indiqué que nous devons appliqué cette table comme table temporaire pour l'image ( prévisualisation )
		 */
		void needsApply(QVector<QRgb>);
		
	public slots:
	
		/*!
		 * \brief Appelée lorsque l'utilisateur change la couleur courante. Change la couleur de la boite de prévisualisation de la couleur courante.
		 */
		void changeFrameColour(int index);
	
		/*!
		 * \brief Appelée lorsque l'utilisateur clique sur le bouton colour. Ouvre un QColourDialog pour avoir une nouvelle couleur.
		 */
		void changeColour(void);
		
		/*!
		 * \brief Appelée lors d'un clic sur le bouton cancel
		 */
		void cancel(void);
		
		/*!
		 * \brief Appelée lors d'un clic sur le bouton apply
		 */
		void apply(void);
		
		/*!
		 * \brief Appelée lors d'un clic sur le bouton Ok
		 */
		void validate(void);
		
	
	public:
	
		/*!
		 *  \brief Constructeur
		 *
		 *  \param table : la table de couleur qui va être modifié.
		 *  \param parent : La fenêtre parente.
		 */
		ColourDialog(const QVector<QRgb>& table, QWidget* parent = 0);
		
		/*!
		 * \brief Destructeur
		 */
		~ColourDialog(void);
		
		/*!
		 *  \brief Getteur pour la table des couleurs.
		 *  \return La nouvelle table de couleur.
		 */
		QVector<QRgb> getTable(void)const { return table; };
};

#endif
