/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "FrameColored.hpp"

#include <QWidget>
#include <QPainter>
#include <QPaintEvent>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

FrameColored :: FrameColored(QColor color, QWidget* parent /*= 0*/)
	:QFrame(parent), color(color)
{
	this->setMinimumSize(50,50);
	this->setGeometry(0,0,50,50);
	
#ifndef QT_NO_DEBUG
	std::cout << "FrameColored created" << std::endl;
#endif
}

FrameColored :: ~FrameColored(void)
{
#ifndef QT_NO_DEBUG
	std::cout << "FrameColored deleted" << std::endl;
#endif
}

void FrameColored :: paintEvent(QPaintEvent* /*event*/)
{
#ifndef QT_NO_DEBUG
	std::cout << "FrameColore :: paintEvent()" << std::endl;
#endif	

	QPainter p(this);

	p.fillRect(QRect(0, 0, this->width(), this->height()), color);
	
	p.setPen(QColor(0, 0, 0));
	p.drawLine(0, 0, this->width()-1, 0);
	p.drawLine(this->width()-1, 0, this->width()-1, this->height()-1);
	p.drawLine(this->width()-1, this->height()-1, 0, this->height()-1);
	p.drawLine(0, this->height()-1, 0, 0);
}
