#ifndef __FRAMECOLORED_HPP__
#define __FRAMECOLORED_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QFrame>
#include <QColor>

class QWidget;
class QPaintEvent;

/*! \class ColoursDialog
 * \brief Frame pour afficher une couleur.
 */
class FrameColored : public QFrame
{
	Q_OBJECT
	
	private:
	
		QColor color;		/*!< La couleur affiché */
		
	protected:
	
		/*!
		 * \brief Surcharge de paintEvent
		 * \param evenement de painture
		 */
		void paintEvent(QPaintEvent* event);
	
	public:
		
		/*!
		 *  \brief Constructeur
		 *
		 *  \param color : la couleur à afficher.
		 *  \param parent : La fenêtre parente.
		 */
		FrameColored(QColor color, QWidget* parent = 0);
		
		/*!
		 * \brief Destructeur
		 */
		~FrameColored(void);
		
		/*!
		 * \brief Definit une nouvelle couleur
		 * \param color : la nouvelle couleur
		 */
		void setColor(QColor newColor) {color = newColor; };
		
		/*!
		 * \brief Getteur de la couleur
		 * \return la couleur
		 */
		QColor getColor(void) {return color; };
};

#endif
