/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "GammaDialog.hpp"

#include <QGridLayout>
#include <QSlider>
#include <QDoubleSpinBox>
#include <QPushButton>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

GammaDialog :: GammaDialog(QWidget* parent /*=0*/)
	:QDialog(parent),
	pGammaValue(NULL),
	pValidateButton(NULL), pApplicateButton(NULL), pCancelButton(NULL)
{
	pMainLayout = new QGridLayout(this);
	
	pGammaValue = new QSlider(Qt::Horizontal, this);
	
	pGammaValue->setTickInterval(1);
	pGammaValue->setRange(0, 200);
	pGammaValue->setValue(100);
	
	pMainLayout->addWidget(pGammaValue, 0, 0);
	
	connect(pGammaValue, SIGNAL(valueChanged(int)), this, SLOT(synchroniseValueSTODSB(int)));
	
	pGammaValueSpinBox = new QDoubleSpinBox(this);
	
	pGammaValueSpinBox->setRange(0, 2);
	pGammaValueSpinBox->setDecimals(2);
	pGammaValueSpinBox->setSingleStep(0.01);
	pGammaValueSpinBox->setValue(1);
	
	pMainLayout->addWidget(pGammaValueSpinBox, 0,1);
	
	connect(pGammaValueSpinBox, SIGNAL(valueChanged(double)), this, SLOT(synchroniseValueDSBTOS(double)));
	
	pValidateButton = new QPushButton(tr("Ok"), this);
	pApplicateButton = new QPushButton(tr("Apply"), this);
	pCancelButton = new QPushButton(tr("Cancel"), this);
	
	pMainLayout->addWidget(pValidateButton, 1, 0);
	pMainLayout->addWidget(pApplicateButton, 1, 1);
	pMainLayout->addWidget(pCancelButton, 1, 2);
	
	connect(pValidateButton, SIGNAL(clicked()), this, SLOT(validateGamma()));
	connect(pApplicateButton, SIGNAL(clicked()), this, SLOT(applicateGamma()));
	connect(pCancelButton, SIGNAL(clicked()), this, SLOT(cancelGamma()));

#ifndef QT_NO_DEBUG
	std::cout << "GammaDialog created" << std::endl;
#endif	
}

GammaDialog :: ~GammaDialog(void)
{
	delete pGammaValue;
	delete pGammaValueSpinBox;
	
	delete pValidateButton;
	delete pApplicateButton;
	delete pCancelButton;
	
	delete pMainLayout;
	
#ifndef QT_NO_DEBUG
	std::cout << "GammaDialog deleted" << std::endl;
#endif	
}

void GammaDialog :: validateGamma(void)
{
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: validateGamma()" << std::endl;
#endif		

	this->done(0);
}

void GammaDialog :: applicateGamma(void)
{
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: applicateGamma()" << std::endl;
#endif

	emit valueChanged(pGammaValueSpinBox->value());
}

void GammaDialog :: cancelGamma(void)
{
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: cancelGamma()" << std::endl;
#endif		

	this->done(1);
}

void GammaDialog :: synchroniseValueSTODSB(int value)
{
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: synchroniseValueSTODSB(): " << value << std::endl;
#endif

	if ( value != static_cast<int>(pGammaValueSpinBox->value() * 100) )
	{
		pGammaValueSpinBox->setValue(value/100.0);
	}
}

void GammaDialog :: synchroniseValueDSBTOS(double value)
{
#ifndef QT_NO_DEBUG
	std::cout << "SLOT: synchroniseValueDSBTOS(): " << value << std::endl;
#endif

	if ( static_cast<int>(value * 100) != pGammaValue->value() )
	{
		pGammaValue->setValue(value*100);
	}
}
