#ifndef __GAMMADIALOG_HPP__
#define __GAMMADIALOG_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QDialog>

class QWidget;
class QGridLayout;
class QSlider;
class QDoubleSpinBox;
class QLabel;
class QPushButton;

/*! \class GammaDialog
 * \brief Dialogue pour demander une nouvelle valeur de gamma.
 */
class GammaDialog : public QDialog
{
	Q_OBJECT
	
	private:
	
		QGridLayout* pMainLayout;				/*!< Grille pour l'agencement de la fenêtre */
		
		QSlider* pGammaValue;					/*!< Slider pour le gamma */
		QDoubleSpinBox* pGammaValueSpinBox;		/*!< QSpinBox pour le gamma ( connectée au slider ) */
	
		QPushButton* pValidateButton;			/*!< Bouton de validation du nouveau gamma */
		QPushButton* pApplicateButton;			/*!< Bouton pour appliquer ( visualisation ) du nouveau gamme */
		QPushButton* pCancelButton;				/*!< Bouton pour annuler */
		
	signals:
		/*!
		 * Signal pour dire que la valeur à changer ( donc pour faire la prévisualisation )
		 */
		void valueChanged(double );
		
	public slots:
	
		/*!
		 * \brief Appelée lors du clic sur le bouton validate. Validation du gamma. 
		 */
		void validateGamma(void);
		
		/*!
		 * \brief Appelée lors du clic sur le bouton apply.\n
		 * Applique le nouveau gamma ( visualisation ).\n
		 * Lance le signal valueChanged
		 */
		void applicateGamma(void);
		
		/*!
		 * \brief Appelée lors du clic sur le bouton cancel.
		 */
		void cancelGamma(void);
		
		/*!
		 * \brief Appelée lors du changement du slider.\n
		 * Provoque la mise à jour du QSpinBox.
		 */
		void synchroniseValueSTODSB(int value);
		
		/*!
		 * \brief Appelée lors du changement du spin box.\n
		 * Provoque la mise à jour du QSlider.
		 */
		void synchroniseValueDSBTOS(double value);
	
	public:
	
		/*!
		 *  \brief Constructeur
		 *
		 *  \param parent : La fenêtre parente.
		 */
		GammaDialog(QWidget* parent = 0);
		
		/*!
		 * \brief Destructeur
		 */
		~GammaDialog(void);
};

#endif
