/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "GradientDialog.hpp"

#include "FrameColored.hpp"

#include <QWidget>
#include <QGridLayout>
#include <QPushButton>
#include <QColorDialog>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

GradientDialog :: GradientDialog(const QColor color1, const QColor color2, QWidget* parent /*= 0*/)
	:QDialog(parent),
	startingColor(color1), endingColor(color2),
	pMainLayout(NULL),
	pColorButton1(NULL), pColorButton2(NULL),
	pFrameColor1(NULL), pFrameColor2(NULL),
	pValidateButton(NULL), pCancelButton(NULL)
{
	pMainLayout = new QGridLayout(this);
	
	pColorButton1 = new QPushButton(tr("Colour1"), this);
	pColorButton2 = new QPushButton(tr("Colour2"), this);
	
	pMainLayout->addWidget(pColorButton1, 0, 0);
	pMainLayout->addWidget(pColorButton2, 0, 3);
	
	pFrameColor1 = new FrameColored(startingColor, this);
	pFrameColor2 = new FrameColored(endingColor, this);
	
	pMainLayout->addWidget(pFrameColor1, 0, 1);
	pMainLayout->addWidget(pFrameColor2, 0, 2);
		
	pValidateButton = new QPushButton(tr("Ok"), this);
	pCancelButton = new QPushButton(tr("Cancel"), this);
	
	pMainLayout->addWidget(pValidateButton, 1, 0);
	pMainLayout->addWidget(pCancelButton, 1, 3);
	
	connect(pColorButton1, SIGNAL(clicked(void)), this, SLOT(setColor1(void)));
	connect(pColorButton2, SIGNAL(clicked(void)), this, SLOT(setColor2(void)));
	
	connect(pValidateButton, SIGNAL(clicked(void)), this, SLOT(validate(void)));
	connect(pCancelButton, SIGNAL(clicked(void)), this, SLOT(cancel(void)));
	
	//pFrameColor1->repaint();
	//pFrameColor2->repaint();

#ifndef QT_NO_DEBUG
	std::cout << "GradientDialog created" << std::endl;
#endif
}

GradientDialog :: ~GradientDialog(void)
{
	delete pCancelButton;
	delete pValidateButton;
	
	delete pFrameColor2;
	delete pFrameColor1;
	
	delete pColorButton2;
	delete pColorButton1;
	
	delete pMainLayout;
	
#ifndef QT_NO_DEBUG
	std::cout << "GradientDialog deleted" << std::endl;
#endif
}

void GradientDialog :: setColor1(void)
{
	QColor newColour = QColorDialog::getColor(startingColor, this, tr("Select you starting colour for the gragient"));;
	
	if ( newColour.isValid() )
	{
		startingColor = newColour;
		pFrameColor1->setColor(startingColor);
		pFrameColor1->repaint();
	}
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT -> GradientDialog::setColor1()" << std::endl;
#endif
}
void GradientDialog :: setColor2(void)
{
	QColor newColour = QColorDialog::getColor(endingColor, this, tr("Select you ending colour for the gragient"));
	
	if ( newColour.isValid() )
	{
		endingColor = newColour;
		pFrameColor2->setColor(endingColor);
		pFrameColor2->repaint();
	}
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT -> GradientDialog::setColor2()" << std::endl;
#endif
}

void GradientDialog :: validate(void)
{
	this->done(0);
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT -> GradientDialog::validate()" << std::endl;
#endif
}

void GradientDialog :: cancel(void)
{
	this->done(1);
	
#ifndef QT_NO_DEBUG
	std::cout << "SLOT -> GradientDialog::cancel()" << std::endl;
#endif
}
