#ifndef __GRADIENTDIALOG_HPP__
#define __GRADIENTDIALOG_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QDialog>
#include <QColor>

class FrameColored;

class QWidget;
class QGridLayout;
class QPushButton;

/*! \class GradientDialog
 * \brief Dialogue pour demander deux couleurs à l'utilisateur.
 */
class GradientDialog : public QDialog
{
	Q_OBJECT
	
	private:
	
		QColor startingColor;			/*!< La couleur de départ ( pour l'interpolation ) */
		QColor endingColor;				/*!< La couleur de fin ( pour l'interpolation ) */
		
		QGridLayout* pMainLayout;		/*!< La grille pour l'agencement */
		
		QPushButton* pColorButton1;		/*!< Bouton pour changer la première couleur */
		QPushButton* pColorButton2;		/*!< Bouton pour changer la deuxième couleur */
		
		FrameColored* pFrameColor1;		/*!< Affichage de la première couleur */
		FrameColored* pFrameColor2;		/*!< Affichage de la deuxième couleur */
		
		QPushButton* pValidateButton;	/*!< Bouton pour valider */
		QPushButton* pCancelButton;		/*!< Bouton pour annuler */
		
	public slots:
	
		/*!
		 * \brief Appelée lorsque l'utilisateur clic sur le bouton pour changer la première couleur.\n
		 * Appel un QColorDialog et change la couleur
		 */
		void setColor1(void);
		
		/*!
		 * \brief Appelée lorsque l'utilisateur clic sur le bouton pour changer la deuxième couleur.\n
		 * Appel un QColorDialog et change la couleur
		 */
		void setColor2(void);
	
		/*!
		 * \brief Appelée lorsque l'utilisateur clic sur le bouton Ok.\n
		 */
		void validate(void);
		
		/*!
		 * \brief Appelée lorsque l'utilisateur clic sur le bouton cancel.\n
		 */
		void cancel(void);
	
	public:
	
		/*!
		 *  \brief Constructeur
		 *
		 *  \param color1 : La première couleur ( couleur de départ )
		 *  \param color2 : La deuxième couleur ( couleur de fin )
		 *  \param parent : La fenêtre parente.
		 */
		GradientDialog(const QColor color1, const QColor color2, QWidget* parent = 0);
		
		/*!
		 * \brief Destructeur
		 */
		~GradientDialog(void);
		
		/*!
		 * \brief Getteur pour la couleur de départ
		 * \return La couleur de départ
		 */
		QColor getStartingColor(void)const { return startingColor; };
		
		/*!
		 * \brief Getteur pour la couleur de fin
		 * \return La couleur de fin
		 */
		QColor getEndingColor(void)const { return endingColor; };
};

#endif
