/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "PaletteDisplayer.hpp"

#include <QPainter>
#include <QPaintEvent>
#include <QGroupBox>
#include <QPushButton>

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

PaletteDisplayer :: PaletteDisplayer(QVector<QRgb> palette, QWidget* parent/*=0*/)
	:QWidget(parent), palette(palette)
{
	this->setMinimumSize(260, 52);
	this->setMaximumSize(260, 52);
	//this->resize(260, 52);
	this->setGeometry(0,0, 260, 52);
	
	pPaletteBox = new QGroupBox(tr("palette"), this);
	pPaletteBox->setGeometry(0, 0, 258, 50);
	
#ifndef QT_NO_DEBUG
	std::cout << "PaletteDisplayer created" << std::endl;
#endif	
}

PaletteDisplayer :: ~PaletteDisplayer(void)
{
	delete pPaletteBox;
	
#ifndef QT_NO_DEBUG
	std::cout << "PaletteDisplayer deleted" << std::endl;
#endif	
}

void PaletteDisplayer :: paintEvent(QPaintEvent* /*event*/)
{
	QPainter painter(this);
	int step = 1;

	//std::cout << "PaletteDisplayer :: paintEvent -> Width: " << width << " step: " << step << std::endl;
	
	for ( unsigned int i = 0 ; i < 256 ; i++ )
	{
		painter.fillRect(QRect(i * step, 17, step, pPaletteBox->height() - 20), QColor(palette[i]));
	}
}
