#ifndef __PALETTEDISPLAYER_HPP__
#define __PALETTEDISPLAYER_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/
#include <QWidget>
#include <QVector>
#include <QColor>

class QGroupBox;
class QPaintEvent;

/*! \class PaletteDisplayer
 * \brief Un widget pour affiché une palette de couleur
 */
class PaletteDisplayer : public QWidget
{
	Q_OBJECT
	
	private:
	
		QGroupBox* pPaletteBox;	/*!< Petit encadrement pour la palette */
		
		QVector<QRgb> palette;	/*!< Palette de couleur */
	
	protected:
	
		/*!
		 * \brief Surcharge pour dessiner le widget
		 */
		void paintEvent(QPaintEvent* event);
	
	public:
	
		/*!
		 * \brief Constructeur
		 * \param palette : la palette à afficher
		 * \param parent : la fenêtre parente
		 */
		PaletteDisplayer(QVector<QRgb> palette, QWidget* parent=0);
		
		/*!
		 * \brief Destructeur
		 */
		~PaletteDisplayer(void);

		/*!
		 * \brief Défini la palette à afficher
		 * \param newPalette : la nouvelle palette
		 */		
		void setPalette(QVector<QRgb> newPalette) { this->palette = newPalette; this->repaint(); };
};

#endif
