#ifndef __PIXMAPWIDGET_HPP__
#define __PIXMAPWIDGET_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/
/**
 * Cette classe est fortement inspirée de: http://qt4.digitalfanatics.org/articles/zoomer.html
 */

#include <QWidget>
#include <QImage>

class QPaintEvent;
class QMouseEvent;
class QKeyEvent;

/*! \class PixmapWidget
 * \brief Un widget pour affiché une image.\n
 * Permet aussi de faire une selection avec un rectangle pour faire un zoom.
 */
class PixmapWidget : public QWidget
{
	Q_OBJECT
	
	private:
	
		QImage* img;	/*!< L'image à afficher */
		
		bool clicked;	/*!< Retient si l'utilisateur à fait un clic gauche */
		QPoint startMousePosition;		/*!< Point de départ de la selection */
		QPoint actualMousePosition;		/*!< Point actuel de la souris durant la selection */
		
		// Gestion de la souris pour le zoom
		/*!
		 * \brief Surcharge pour récupéré les clics
		 * \param event : un pointeur sur la structure de l'évenement
		 */
		void mousePressEvent(QMouseEvent* event);
		
		/*!
		 * \brief Surcharge pour récupéré les déplacements de la souris
		 * \param event : un pointeur sur la structure de l'évenement
		 */
		void mouseMoveEvent(QMouseEvent* event);
		
		/*!
		 * \brief Surcharge pour récupéré les relachement des clis
		 * \param event : un pointeur sur la structure de l'évenement
		 */
		void mouseReleaseEvent(QMouseEvent* event);
		
		// Pour l'annulation de la selection
		/*!
		 * \brief Surcharge pour récupéré les touches appuyées
		 * \param event : un pointeur sur la structure de l'évenement
		 */
		void keyReleaseEvent(QKeyEvent* event);
		
	protected:
	
		/*!
		 * \brief Surcharge pour dessiner l'image et le rectangle de sélection
		 * \param event : un pointeur sur la structure de l'évenement
		 */
		void paintEvent(QPaintEvent* event);
		
		
	signals:
	
		/*!
		 * \brief Signal pour indiquer un zoom
		 */
		void zoom(QPoint start, QPoint end);
		
		/*!
		 * \brief Signal pour indiquer un dezoom
		 */
		void unzoom();
	
	public:
	
		/**
		 * \brief Constructeur
		 * \param pixmap : l'image à afficher
		 * \param parent : la fenêtre parente
		 */
		PixmapWidget(QImage* image, QWidget* parent=0);
		
		/**
		 * \brief Destructeur
		 */
		~PixmapWidget(void);
		
		//void setPixmap(QPixmap* newPixmap) { pix = newPixmap; };
};

#endif
