/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "ProgressDialog.hpp"

//#ifndef QT_NO_DEBUG
	#include <iostream>
//#endif

extern short unsigned int nbCore;

#ifdef _CALLBACK_QT
	ProgressFeedBack pf;

	void retourPourcentage(int value)
	{
		pf.updateValue(value);
	}
#endif

ProgressDialog :: ProgressDialog(const QString& title, QWidget* parent /*= 0*/)
	:QProgressDialog(tr("Generation of the ") + title, tr("Cancel"), 0, 100, parent)
{
	previousValue = 0;
	
	// Limité aux pourcentages
	this->setRange(0, 100);	
	this->setValue(0);
	
	this->setLabelText(tr("Generation ") + title + QString(": ..."));
	
	// Finalement, on ne peut pas annuler car ... cela n'arrêterait pas le thread
	// Solution: Passer un flag dans le thread pour pouvoir l'arrêter ( je parle dans la fonction de Yan )
	this->setCancelButton(0);
	
#ifndef QT_NO_DEBUG
	std::cout << "ProgressDialog created" << std::endl;
#endif
}

ProgressDialog :: ~ProgressDialog(void)
{

#ifndef QT_NO_DEBUG
	std::cout << "ProgressDialog deleted" << std::endl;
#endif	
}

void ProgressDialog :: progressValue(int newValue)
{
	// Cette methode est loin d'être parfaite
	// La vraie méthode c'est de passer une variable de progression au thread ( unique à chaque thread ) ( vu que ici on se bat entre tout nos threads pour savoir la progression )
	if ( newValue < previousValue )
	{
		this->setValue(newValue);
	}
	else
	{
		if ( newValue - this->value() < 3 )	
		{
			this->setValue(newValue);	
		}
	}
	
	previousValue = newValue;
}
