#ifndef __PROGRESSDIALOG_HPP__
#define __PROGRESSDIALOG_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QProgressDialog>

/*! \class ProgressDialog
 * \brief Surcharge du QProgressDialog afin d'avoir une boite de progression de la tache
 */
class ProgressDialog : public QProgressDialog
{
	Q_OBJECT
	
	private:
	
		int previousValue;
	
	protected slots:
		/*!
		 * \brief Change la valeur de la progression
		 */
		void progressValue(int newValue);
	
	public:
	
		/*!
		 * \brief Constructeur
		 * \param title : Titre de la fenêtre
		 * \param parent : Fenere parente
		 */
		ProgressDialog(const QString& title, QWidget* parent = 0);
		
		/*!
		 * \brief Destructeur
		 */
		~ProgressDialog(void);
};

#ifdef _CALLBACK_QT
	/*! \class ProgressFeedBack
	 * \brief Permet juste d'avoir un objet qui peut lancer des signaux
	 */
	class ProgressFeedBack : public QObject
	{
		Q_OBJECT
		
		private:
		
		signals:
		
			/*!
			 * \brief Envoi d'un signal pour le changement de la valeur
			 */
			void sendNewValue(int);
		
		public:
		
			/*!
			 * \brief Fonction qui envoie le signal
			 */
			void updateValue(int newValue)
			{
				emit sendNewValue(newValue);
			}
	};
#endif

#endif
