/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "PromptCurveDialog.hpp"

#include <QWidget>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QGroupBox>
#include <QComboBox>
#include <QSpinBox>
#include <QDoubleSpinBox>
#include <QPushButton>
#include <QLabel>

#include "../types.hpp"

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

extern const char* initFCTString[lifctENDOFLIST];
extern const char* accumulateurFCTString[lafctENDOFLIST];

PromptCurveDialog :: PromptCurveDialog(QWidget* parent /*= 0*/)
	:QDialog(parent),
	// Tout pointeur est mis à zero
	//pCentralArea(NULL),
	pMainGrid(NULL),
	pFunctionsBox(NULL), pZoneBox(NULL), pFunctionsGrid(NULL), pZoneGrid(NULL), pButtonsGrid(NULL),
	
	pLabelCurvesList(NULL),		pCurvesList(NULL),
	
		
	pPointBox(NULL), pParamBox(NULL), pZoneSizeBox(NULL), pZoneGeneratorBox(NULL), pPointGrid(NULL), pParamGrid(NULL), pZoneSizeGrid(NULL), pZoneGeneratorGrid(NULL),
	
	pLabelNbPoints(NULL), pNbPoints(NULL),
	pLabelPointX(NULL), pPointX(NULL),
	pLabelPointY(NULL), pPointY(NULL),
	
	// Paramètres
	pLabelPA(NULL), pPA(NULL),
	pLabelPB(NULL), pPB(NULL),
	pLabelPC(NULL), pPC(NULL),
	pLabelPD(NULL), pPD(NULL),
	
	pLabelWidth(NULL),	pWidth(NULL),
	pLabelHeight(NULL),	pHeight(NULL),
	pLabelX(NULL), pX(NULL),
	pLabelY(NULL), pY(NULL),
	pLabelW(NULL), pW(NULL),
	pLabelH(NULL), pH(NULL),
	
	pCancelButton(NULL),
	pDefaultButton(NULL),
	pStartButton(NULL)
{	
	// Creation de la grille principale
	pMainGrid = new QGridLayout(this);
	
	this->createListsFunctions();
	
	this->createSpinBoxes();
	
	this->createButtons();
	
		
#ifndef QT_NO_DEBUG
	std::cout << "PromptCurveDialog created" << std::endl;
#endif
}

void PromptCurveDialog :: createButtons(void)
{
	const int actualRowNumber = pMainGrid->rowCount();
	
	pButtonsGrid = new QHBoxLayout(0);
	pMainGrid->addLayout(pButtonsGrid, actualRowNumber, 0, Qt::AlignRight);
	
	pStartButton = new QPushButton(tr("Start"), this);
	pButtonsGrid->addWidget(pStartButton);
	
	pDefaultButton = new QPushButton(tr("Default"), this);
	pButtonsGrid->addWidget(pDefaultButton);
	
	pCancelButton = new QPushButton(tr("Cancel"), this);
	pButtonsGrid->addWidget(pCancelButton);
	
	connect(pStartButton, SIGNAL(clicked()), this, SLOT(startGeneration()));
	connect(pDefaultButton, SIGNAL(clicked()), this, SLOT(applyDefaultValues()));
	connect(pCancelButton, SIGNAL(clicked()), this, SLOT(cancelSettings()));

#ifndef QT_NO_DEBUG
	std::cout << "\tPromptCurveDialog buttons created" << std::endl;
#endif
}

void PromptCurveDialog :: createListsFunctions(void)
{
	pFunctionsBox = new QGroupBox(tr("Functions:"), this);
	pMainGrid->addWidget(pFunctionsBox,1,0,Qt::AlignCenter);
	
	pFunctionsGrid = new QGridLayout(pFunctionsBox);
	
	pLabelCurvesList = new QLabel(tr("List of functions for fractales:"), this);
	pCurvesList = new QComboBox(this);
	
	// Ajout des éléments
	for ( unsigned int i = 0 ; i < lcfctENDOFLIST ; i++ )
	{
		pCurvesList->addItem(curveFCTString[i].name, i);
	}
	
	connect(pCurvesList, SIGNAL(currentIndexChanged(int)), this, SLOT(functionSelectedChanged(int)));
	
	pFunctionsGrid->addWidget(pLabelCurvesList, 1, 0, Qt::AlignLeft);
	pFunctionsGrid->addWidget(pCurvesList, 1, 1, Qt::AlignCenter);
	
#ifndef QT_NO_DEBUG
	std::cout << "\tPromptCurveDialog: Lists created" << std::endl;
#endif
}

void PromptCurveDialog :: createSpinBoxes(void)
{
	pPointBox = new QGroupBox(tr("Point settings:"), this);
	pMainGrid->addWidget(pPointBox,1,1,Qt::AlignLeft);
	
	pParamBox = new QGroupBox(tr("Param settings:"), this);
	pMainGrid->addWidget(pParamBox,2,1,Qt::AlignCenter);
	
	pZoneBox = new QGroupBox(tr("Zone settings:"), this);
	pMainGrid->addWidget(pZoneBox,2,0,Qt::AlignCenter);
	
	pZoneGrid = new QHBoxLayout(pZoneBox);
	
	// Point
	{		
		pPointGrid = new QGridLayout(pPointBox);
		
		pLabelNbPoints = new QLabel(tr("Number of points:"), this);
		pNbPoints = new QSpinBox(this);
		
		pNbPoints->setMaximum(2147483647);
		pNbPoints->setValue(10000);
		
		pPointGrid->addWidget(pLabelNbPoints, 0, 0, Qt::AlignLeft);
		pPointGrid->addWidget(pNbPoints, 0, 1, Qt::AlignCenter);
		
		pLabelPointX = new QLabel(tr("Point X:"), this);
		pPointX = new QDoubleSpinBox(this);
		
		pPointX->setDecimals(3);
		pPointX->setRange(-2147483647, 2147483647);
		
		pPointGrid->addWidget(pLabelPointX, 1, 0, Qt::AlignLeft);
		pPointGrid->addWidget(pPointX, 1, 1, Qt::AlignCenter);
		
		pLabelPointY = new QLabel(tr("Point Y:"), this);
		pPointY = new QDoubleSpinBox(this);
		
		pPointY->setDecimals(3);
		pPointY->setRange(-2147483647, 2147483647);
		
		pPointGrid->addWidget(pLabelPointY, 2, 0, Qt::AlignLeft);
		pPointGrid->addWidget(pPointY, 2, 1, Qt::AlignCenter);
	}
	
	// Params
	{
		pParamGrid = new QGridLayout(pParamBox);
		
		pLabelPA = new QLabel(tr("PA:"), this);
		pPA = new QDoubleSpinBox(this);
		
		pPA->setDecimals(3);
		pPA->setRange(-2147483647, 2147483647);
		
		pParamGrid->addWidget(pLabelPA, 0, 0, Qt::AlignLeft);
		pParamGrid->addWidget(pPA, 0, 1, Qt::AlignCenter);
		
		pLabelPB = new QLabel(tr("PB:"), this);
		pPB = new QDoubleSpinBox(this);
		
		pPB->setDecimals(3);
		pPB->setRange(-2147483647, 2147483647);
		
		pParamGrid->addWidget(pLabelPB, 1, 0, Qt::AlignLeft);
		pParamGrid->addWidget(pPB, 1, 1, Qt::AlignCenter);
		
		pLabelPC = new QLabel(tr("PC:"), this);
		pPC = new QDoubleSpinBox(this);
		
		pPC->setDecimals(3);
		pPC->setRange(-2147483647, 2147483647);
		
		pParamGrid->addWidget(pLabelPC, 2, 0, Qt::AlignLeft);
		pParamGrid->addWidget(pPC, 2, 1, Qt::AlignCenter);
		
		pLabelPD = new QLabel(tr("PD:"), this);
		pPD = new QDoubleSpinBox(this);
		
		pPD->setDecimals(3);
		pPD->setRange(-2147483647, 2147483647);
		
		pParamGrid->addWidget(pLabelPD, 3, 0, Qt::AlignLeft);
		pParamGrid->addWidget(pPD, 3, 1, Qt::AlignCenter);
	}
	
	// Taille image
	{	
		pZoneSizeBox = new QGroupBox(tr("Image size:"), this);
		pZoneGrid->addWidget(pZoneSizeBox);
		
		pZoneSizeGrid = new QGridLayout(pZoneSizeBox);
		
		pLabelWidth = new QLabel(tr("Image width:"), this);
		pWidth = new QSpinBox(this);
		
		pWidth->setMaximum(2147483647);
		pWidth->setValue(1000);
		
		pZoneSizeGrid->addWidget(pLabelWidth, 0, 0, Qt::AlignLeft);
		pZoneSizeGrid->addWidget(pWidth, 0, 1, Qt::AlignCenter);
		
		pLabelHeight = new QLabel(tr("Image height:"), this);
		pHeight = new QSpinBox(this);
		
		pHeight->setMaximum(2147483647);
		pHeight->setValue(1000);
		
		pZoneSizeGrid->addWidget(pLabelHeight, 1, 0, Qt::AlignLeft);
		pZoneSizeGrid->addWidget(pHeight, 1, 1, Qt::AlignCenter);
	}
	
	// Zone
	{
		pZoneGeneratorBox = new QGroupBox(tr("Fractale settings:"), this);
		pZoneGrid->addWidget(pZoneGeneratorBox);
		
		pZoneGeneratorGrid = new QGridLayout(pZoneGeneratorBox);
		
		pLabelX = new QLabel(tr("X:"), this);
		pX = new QDoubleSpinBox(this);
		
		pX->setDecimals(3);
		pX->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelX, 0, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pX, 0, 1, Qt::AlignCenter);
		
		pLabelY = new QLabel(tr("Y:"), this);
		pY = new QDoubleSpinBox(this);
		
		pY->setDecimals(3);
		pY->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelY, 1, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pY, 1, 1, Qt::AlignCenter);
		
		pLabelW = new QLabel(tr("W:"), this);
		pW = new QDoubleSpinBox(this);
		
		pW->setDecimals(3);
		pW->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelW, 2, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pW, 2, 1, Qt::AlignCenter);
		
		pLabelH = new QLabel(tr("H:"), this);
		pH = new QDoubleSpinBox(this);
		
		pH->setDecimals(3);
		pH->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelH, 3, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pH, 3, 1, Qt::AlignCenter);
	}
	
	this->applyDefaultValues();
	
#ifndef QT_NO_DEBUG
	std::cout << "\tPromptDialog: Spin Boxes created" << std::endl;
#endif
}

PromptCurveDialog :: ~PromptCurveDialog(void)
{
	// Bouttons
	delete pStartButton;
	delete pDefaultButton;
	delete pCancelButton;
	
	//Zone
	delete pH;	delete pLabelH;
	delete pW;	delete pLabelW;
	delete pY;	delete pLabelY;
	delete pX;	delete pLabelX;
	
	delete pHeight;	delete pLabelHeight;
	delete pWidth;	delete pLabelWidth;
	
	// Paramètres
	
	delete pLabelPA; delete pPA;
	delete pLabelPB; delete pPB;
	delete pLabelPC; delete pPC;
	delete pLabelPD; delete pPD;
	
	// Point
	delete pPointY; delete pLabelPointY;
	delete pPointX; delete pLabelPointX;
	delete pNbPoints; delete pLabelNbPoints;
	
	delete pZoneGeneratorGrid;
	delete pZoneSizeGrid;
	
	delete pZoneGeneratorBox;
	delete pZoneSizeBox;
	
	// Listes
	delete pCurvesList;		delete pLabelCurvesList;
	
	// Interface
	delete pPointGrid;
	delete pParamGrid;
	delete pZoneGrid;
	delete pFunctionsGrid;
	delete pButtonsGrid;
	
	delete pPointBox;
	delete pParamBox;
	delete pZoneBox;
	delete pFunctionsBox;
	
	delete pMainGrid;
	
	//delete pCentralArea;

#ifndef QT_NO_DEBUG
	std::cout << "PromptCurveDialog deleted" << std::endl;
#endif	
}

/// SLOTS

void PromptCurveDialog :: startGeneration(void)
{

	// ToDO: Verification des paramètres selectionné

#ifndef QT_NO_DEBUG
	std::cout << "Starting of the generation" << std::endl;
	// ToDo: Affichage des paramètres selectionnées
#endif	

	this->done(0);
}

void PromptCurveDialog :: cancelSettings(void)
{
	this->close();
}

void PromptCurveDialog :: reject(void)
{
	this->done(1);

#ifndef QT_NO_DEBUG
	std::cout << "PromptDialog canceled" << std::endl;
#endif	
}

void PromptCurveDialog :: functionSelectedChanged(int index)
{
	(void)index;	// Petite astuce pour enlever le warning unused variable de index
#ifndef QT_NO_DEBUG
	std::cout << "\t\tPromptDialog: SLOT(functionSelectedChanged) -> index: " << index << std::endl;
#endif	

	applyDefaultValues();
}

void PromptCurveDialog :: applyDefaultValues(void)
{
	int index = pCurvesList->currentIndex();
	
	pX->setValue(curveFCTString[index].x);
	pY->setValue(curveFCTString[index].y);
	pW->setValue(curveFCTString[index].w);
	pH->setValue(curveFCTString[index].h);
	
	pNbPoints->setValue(curveFCTString[index].nbPoints);
	
	pPointX->setValue(curveFCTString[index].pX);
	pPointY->setValue(curveFCTString[index].pY);
	
	pPA->setValue(curveFCTString[index].paramA);
	pPB->setValue(curveFCTString[index].paramB);
	pPC->setValue(curveFCTString[index].paramC);
	pPD->setValue(curveFCTString[index].paramD);
	

#ifndef QT_NO_DEBUG
	std::cout << "\tPromptCurveDialog: SLOT(applyDefaultValues)" << std::endl;
#endif
}

ListCurveFCT PromptCurveDialog :: getCurve(void)const
{
	return static_cast<ListCurveFCT>(pCurvesList->currentIndex());
}

unsigned int PromptCurveDialog :: getNbPoints(void)const
{
	return pNbPoints->value();
}

double PromptCurveDialog :: getPointX(void)const
{
	return pPointX->value();
}

double PromptCurveDialog :: getPointY(void)const
{
	return pPointY->value();
}

double PromptCurveDialog :: getPA(void)const
{
	return pPA->value();
}

double PromptCurveDialog :: getPB(void)const
{
	return pPB->value();
}

double PromptCurveDialog :: getPC(void)const
{
	return pPC->value();
}

double PromptCurveDialog :: getPD(void)const
{
	return pPD->value();
}

unsigned int PromptCurveDialog :: getImageW(void)const
{
	return pWidth->value();
}

unsigned int PromptCurveDialog :: getImageH(void)const
{
	return pHeight->value(); 
}
		
double PromptCurveDialog :: getZoneX(void)const
{
	return pX->value();
}

double PromptCurveDialog :: getZoneY(void)const
{
	return pY->value();
}
	
double PromptCurveDialog :: getZoneW(void)const
{
	return pW->value();
}

double PromptCurveDialog :: getZoneH(void)const
{
	return pH->value();
}
