/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include "PromptGenerationDialog.hpp"

#include <QWidget>
#include <QGridLayout>
#include <QHBoxLayout>
#include <QGroupBox>
#include <QComboBox>
#include <QSpinBox>
#include <QDoubleSpinBox>
#include <QPushButton>
#include <QLabel>

#include "../types.hpp"
//#include "../strings.hpp"

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif
extern const char* initFCTString[lifctENDOFLIST];
extern const char* accumulateurFCTString[lafctENDOFLIST];

PromptGenerationDialog :: PromptGenerationDialog(QWidget* parent /*= 0*/)
	:QDialog(parent),
	// Tout pointeur est mis à zero
	//pCentralArea(NULL),
	pMainGrid(NULL),
	pFunctionsBox(NULL), pZoneBox(NULL), pFunctionsGrid(NULL), pZoneGrid(NULL), pButtonsGrid(NULL),
	
	pLabelInitializorList(NULL),	pInitializorList(NULL),
	pLabelGeneratorsList(NULL),		pGeneratorsList(NULL),
	pLabelAccumulatorList(NULL),	pAccumulatorList(NULL),
	
	pZoneSizeBox(NULL), pZoneGeneratorBox(NULL), pZoneSizeGrid(NULL), pZoneGeneratorGrid(NULL),
	pLabelWidth(NULL),	pWidth(NULL),
	pLabelHeight(NULL),	pHeight(NULL),
	pLabelX(NULL), pX(NULL),
	pLabelY(NULL), pY(NULL),
	pLabelW(NULL), pW(NULL),
	pLabelH(NULL), pH(NULL),
	
	pCancelButton(NULL),
	pDefaultButton(NULL),
	pStartButton(NULL)
{	
	// Creation de la grille principale
	pMainGrid = new QGridLayout(this);
	
	this->createListsFunctions();
	
	this->createSpinBoxes();
	
	this->createButtons();
	
		
#ifndef QT_NO_DEBUG
	std::cout << "PromptGenerationDialog created" << std::endl;
#endif
}

void PromptGenerationDialog :: createButtons(void)
{
	const int actualRowNumber = pMainGrid->rowCount();
	
	pButtonsGrid = new QHBoxLayout(0);
	pMainGrid->addLayout(pButtonsGrid, actualRowNumber, 0, Qt::AlignRight);
	
	pStartButton = new QPushButton(tr("Start"), this);
	pButtonsGrid->addWidget(pStartButton);
	
	pDefaultButton = new QPushButton(tr("Default"), this);
	pButtonsGrid->addWidget(pDefaultButton);
	
	pCancelButton = new QPushButton(tr("Cancel"), this);
	pButtonsGrid->addWidget(pCancelButton);
	
	connect(pStartButton, SIGNAL(clicked()), this, SLOT(startGeneration()));
	connect(pDefaultButton, SIGNAL(clicked()), this, SLOT(applyDefaultValues()));
	connect(pCancelButton, SIGNAL(clicked()), this, SLOT(cancelSettings()));

#ifndef QT_NO_DEBUG
	std::cout << "\tPromptGenerationDialog buttons created" << std::endl;
#endif
}

void PromptGenerationDialog :: createListsFunctions(void)
{
	pFunctionsBox = new QGroupBox(tr("Functions:"), this);
	pMainGrid->addWidget(pFunctionsBox,0,0,Qt::AlignCenter);
	
	pFunctionsGrid = new QGridLayout(pFunctionsBox);
	
	pLabelInitializorList = new QLabel(tr("List of functions for initialisation of the points:"), this);
	pInitializorList = new QComboBox(this);
	
	// Ajout des éléments
	for ( unsigned int i = 0 ; i < lifctENDOFLIST ; i++ )
	{
		pInitializorList->addItem(initFCTString[i], i);
	}
	
	pFunctionsGrid->addWidget(pLabelInitializorList, 0, 0, Qt::AlignLeft);
	pFunctionsGrid->addWidget(pInitializorList, 0, 1, Qt::AlignCenter);
	
	
	pLabelGeneratorsList = new QLabel(tr("List of functions for fractales:"), this);
	pGeneratorsList = new QComboBox(this);
	
	// Ajout des éléments
	for ( unsigned int i = 0 ; i < lgfctENDOFLIST ; i++ )
	{
		pGeneratorsList->addItem(generatorFCTString[i].name, i);
	}
	
	connect(pGeneratorsList, SIGNAL(currentIndexChanged(int)), this, SLOT(functionSelectedChanged(int)));
	
	pFunctionsGrid->addWidget(pLabelGeneratorsList, 1, 0, Qt::AlignLeft);
	pFunctionsGrid->addWidget(pGeneratorsList, 1, 1, Qt::AlignCenter);
	
	
	pLabelAccumulatorList = new QLabel(tr("List of functions for accumulation:"), this);
	pAccumulatorList = new QComboBox(this);
	
	// Ajout des éléments
	for ( unsigned int i = 0 ; i < lafctENDOFLIST ; i++ )
	{
		pAccumulatorList->addItem(accumulateurFCTString[i], i);
	}
	
	pFunctionsGrid->addWidget(pLabelAccumulatorList, 2, 0, Qt::AlignLeft);
	pFunctionsGrid->addWidget(pAccumulatorList, 2, 1, Qt::AlignCenter);

#ifndef QT_NO_DEBUG
	std::cout << "\tPromptGenerationDialog: Lists created" << std::endl;
#endif
}

void PromptGenerationDialog :: createSpinBoxes(void)
{
	pZoneBox = new QGroupBox(tr("Zone settings:"), this);
	pMainGrid->addWidget(pZoneBox,1,0,Qt::AlignCenter);
	
	pZoneGrid = new QHBoxLayout(pZoneBox);
	
	// Taille image
	{	
		pZoneSizeBox = new QGroupBox(tr("Image size:"), this);
		pZoneGrid->addWidget(pZoneSizeBox);
		
		pZoneSizeGrid = new QGridLayout(pZoneSizeBox);
		
		pLabelWidth = new QLabel(tr("Image width:"), this);
		pWidth = new QSpinBox(this);
		
		pWidth->setMaximum(2147483647);
		pWidth->setValue(1000);
		
		pZoneSizeGrid->addWidget(pLabelWidth, 0, 0, Qt::AlignLeft);
		pZoneSizeGrid->addWidget(pWidth, 0, 1, Qt::AlignCenter);
		
		pLabelHeight = new QLabel(tr("Image height:"), this);
		pHeight = new QSpinBox(this);
		
		pHeight->setMaximum(2147483647);
		pHeight->setValue(1000);
		
		pZoneSizeGrid->addWidget(pLabelHeight, 1, 0, Qt::AlignLeft);
		pZoneSizeGrid->addWidget(pHeight, 1, 1, Qt::AlignCenter);
	}
	
	// Zone
	{
		pZoneGeneratorBox = new QGroupBox(tr("Fractale settings:"), this);
		pZoneGrid->addWidget(pZoneGeneratorBox);
		
		pZoneGeneratorGrid = new QGridLayout(pZoneGeneratorBox);
		
		pLabelX = new QLabel(tr("X:"), this);
		pX = new QDoubleSpinBox(this);
		
		pX->setDecimals(3);
		pX->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelX, 0, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pX, 0, 1, Qt::AlignCenter);
		
		pLabelY = new QLabel(tr("Y:"), this);
		pY = new QDoubleSpinBox(this);
		
		pY->setDecimals(3);
		pY->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelY, 1, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pY, 1, 1, Qt::AlignCenter);
		
		pLabelW = new QLabel(tr("W:"), this);
		pW = new QDoubleSpinBox(this);
		
		pW->setDecimals(3);
		pW->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelW, 2, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pW, 2, 1, Qt::AlignCenter);
		
		pLabelH = new QLabel(tr("H:"), this);
		pH = new QDoubleSpinBox(this);
		
		pH->setDecimals(3);
		pH->setRange(-2147483647, 2147483647);
		
		pZoneGeneratorGrid->addWidget(pLabelH, 3, 0, Qt::AlignLeft);
		pZoneGeneratorGrid->addWidget(pH, 3, 1, Qt::AlignCenter);
	}
	
	this->applyDefaultValues();
	
#ifndef QT_NO_DEBUG
	std::cout << "\tPromptGenerationDialog: Spin Boxes created" << std::endl;
#endif
}

PromptGenerationDialog :: ~PromptGenerationDialog(void)
{
	// Bouttons
	delete pStartButton;
	delete pDefaultButton;
	delete pCancelButton;
	
	//Zone
	delete pH;	delete pLabelH;
	delete pW;	delete pLabelW;
	delete pY;	delete pLabelY;
	delete pX;	delete pLabelX;
	
	delete pHeight;	delete pLabelHeight;
	delete pWidth;	delete pLabelWidth;
	
	delete pZoneGeneratorGrid;
	delete pZoneSizeGrid;
	
	delete pZoneGeneratorBox;
	delete pZoneSizeBox;
	
	// Listes
	delete pAccumulatorList;	delete pLabelAccumulatorList;
	delete pGeneratorsList;		delete pLabelGeneratorsList;
	delete pInitializorList;	delete pLabelInitializorList;
	
	// Interface
	delete pZoneGrid;
	delete pFunctionsGrid;
	delete pButtonsGrid;
	
	delete pZoneBox;
	delete pFunctionsBox;
	
	delete pMainGrid;
	
	//delete pCentralArea;

#ifndef QT_NO_DEBUG
	std::cout << "PromptGenerationDialog deleted" << std::endl;
#endif	
}

/// SLOTS

void PromptGenerationDialog :: startGeneration(void)
{

	// ToDO: Verification des paramètres selectionné

#ifndef QT_NO_DEBUG
	std::cout << "Starting of the generation" << std::endl;
	// ToDo: Affichage des paramètres selectionnées
#endif	

	this->done(0);
}

void PromptGenerationDialog :: cancelSettings(void)
{
	this->close();
}

void PromptGenerationDialog :: reject(void)
{
	this->done(1);

#ifndef QT_NO_DEBUG
	std::cout << "PromptGenerationDialog canceled" << std::endl;
#endif	
}

void PromptGenerationDialog :: functionSelectedChanged(int index)
{
	(void)index;	// Petite astuce pour enlever le warning unused index
#ifndef QT_NO_DEBUG
	std::cout << "\tPromptGenerationDialog: SLOT(functionSelectedChanged) -> index: " << index << std::endl;
#endif	

	applyDefaultValues();
}

void PromptGenerationDialog :: applyDefaultValues(void)
{
	int index = pGeneratorsList->currentIndex();
	
	pInitializorList->setCurrentIndex(generatorFCTString[index].lifct);
	pAccumulatorList->setCurrentIndex(generatorFCTString[index].lafct);
	
	pX->setValue(generatorFCTString[index].x);
	pY->setValue(generatorFCTString[index].y);
	pW->setValue(generatorFCTString[index].w);
	pH->setValue(generatorFCTString[index].h);
	

#ifndef QT_NO_DEBUG
	std::cout << "\tPromptGenerationDialog: SLOT(applyDefaultValues)" << std::endl;
#endif
}

ListInitFCT PromptGenerationDialog :: getInitializor(void)const
{
	return static_cast<ListInitFCT>(pInitializorList->currentIndex());
}

ListGeneratorFCT PromptGenerationDialog :: getGenerator(void)const
{
	return static_cast<ListGeneratorFCT>(pGeneratorsList->currentIndex());
}

ListAccumulateurFCT PromptGenerationDialog :: getAccumulator(void)const
{
	return static_cast<ListAccumulateurFCT>(pAccumulatorList->currentIndex());
}

unsigned int PromptGenerationDialog :: getImageW(void)const
{
	return pWidth->value();
}

unsigned int PromptGenerationDialog :: getImageH(void)const
{
	return pHeight->value(); 
}
		
double PromptGenerationDialog :: getZoneX(void)const
{
	return pX->value();
}

double PromptGenerationDialog :: getZoneY(void)const
{
	return pY->value();
}
	
double PromptGenerationDialog :: getZoneW(void)const
{
	return pW->value();
}

double PromptGenerationDialog :: getZoneH(void)const
{
	return pH->value();
}
