/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/
#include "PromptSettings.hpp"

#include <QGridLayout>
#include <QLabel>
#include <QSpinBox>
#include <QPushButton>

#include "global.hpp"

#ifndef QT_NO_DEBUG
	#include <iostream>
#endif

extern short unsigned int nbCore;

PromptSettings :: PromptSettings(QWidget* parent /*= 0*/)
	:QDialog(parent),
	//pCentralWidget(NULL),
	pMainGrid(NULL),
	pNbCoreLabel(NULL),	pNbCore(NULL),
	pCancelButton(NULL), pValidateButton(NULL)
{
	pMainGrid = new QGridLayout(this);
	
	pNbCoreLabel = new QLabel(tr("Number of core that you have:"));
	pNbCore = new QSpinBox();
	
	pNbCore->setRange(1, NB_MAX_CORE);
	// Met la valeur actuel dans la QSpinBox
	pNbCore->setValue(nbCore);
	oldNbCore = nbCore;
	
	// Bloqueles valeurs à des puissances de deux
	connect(pNbCore, SIGNAL(valueChanged(int )), this, SLOT(nbCoreChanged(int )));
	
	pMainGrid->addWidget(pNbCoreLabel,0,0);
	pMainGrid->addWidget(pNbCore,0,1);
	
	pValidateButton = new QPushButton(tr("Ok"), this);
	pCancelButton = new QPushButton(tr("Cancel"), this);
	
	connect(pValidateButton, SIGNAL(clicked()), this, SLOT(validateSettings()));
	connect(pCancelButton, SIGNAL(clicked()), this, SLOT(cancelSettings()));
	
	pMainGrid->addWidget(pValidateButton,1,0);
	pMainGrid->addWidget(pCancelButton,1,1);
	
#ifndef QT_NO_DEBUG
	std::cout << "PromptSettings created" << std::endl;
#endif
}

PromptSettings :: ~PromptSettings(void)
{
	delete pCancelButton;
	delete pValidateButton;
	
	delete pNbCoreLabel;
	delete pNbCore;
	
	delete pMainGrid;
	
#ifndef QT_NO_DEBUG
	std::cout << "PromptSettings deleted" << std::endl;
#endif
}

void PromptSettings :: validateSettings(void)
{
	// Modification dans les variables du programme
	nbCore = pNbCore->value();
	
	this->done(0);
#ifndef QT_NO_DEBUG
	std::cout << "SLOT - PromptSettings::validateSettings (changed to: " << nbCore << ")" << std::endl;
#endif
}

void PromptSettings :: cancelSettings(void)
{
	// Aucune modification à faire, nous partons
	
	this->done(1);
#ifndef QT_NO_DEBUG
	std::cout << "SLOT - PromptSettings::cancelSettings" << std::endl;
#endif
}

void PromptSettings :: nbCoreChanged(int newNbCore)
{
	// Cette fonction permet de n'avoir que des puissances de deux, dans la QSpinBox
	// Mais, en fait, il y a un leger problème dans le code, vu que setValue va entrainer
	// un signal qui rappelera la fonction. Ceci n'a aucune conséquence pour l'utilisateur (grace aux ifs),
	// mais toutefois, une sorte de redondance existe (deux appels à la fonction pour qu'un seul changement).
	if ( newNbCore < oldNbCore )
	{
		pNbCore->setValue(oldNbCore / 2);
	}
	else if ( newNbCore > oldNbCore )
	{
		pNbCore->setValue(oldNbCore * 2);
	}
	
	oldNbCore = pNbCore->value();
}
