#ifndef __PROMPTSETTINGS_HPP__
#define __PROMPTSETTINGS_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QDialog>

class QGridLayout;
class QLabel;
class QSpinBox;
class QPushButton;

/*! \class PromptSettings
 * \brief Surcharge du QDialog afin d'afficher une fenêtre personalisée à l'utilisateur
 */
class PromptSettings : public QDialog
{
	Q_OBJECT
	
	private:
	
		// Design de la boite
		//QWidget* pCentralArea;
		QGridLayout* pMainGrid;			/*!< Grille d'agencement des éléments */
		
		// Configuration pour le processeur
		QLabel* pNbCoreLabel;			/*!< Texte descrivant le paramètre */
		QSpinBox* pNbCore;				/*!< Spin box pour changer le paramètre */
		
		int oldNbCore;					/*!< Ancienne valeur pour le paramètre ( permet l'annulation ) */
		
		// Bouttons
		QPushButton* pCancelButton;		/*!< Bouton d'annulation */
		QPushButton* pValidateButton;	/*!< Bouton de validation */
	
	public slots:
	
		/*!
		 * \brief Appelée lors d'un clic sur le bouton de validation.\n
		 * Valide les nouveaux paramètres
		 */
		void validateSettings(void);
		
		/*!
		 * \brief Appelée lors d'un clic sur le bouton d'annulation.\n
		 */
		void cancelSettings(void);
	
		/*!
		 * \brief Appelée lors du changement de valeur du paramètre.\n
		 * Permet de faire que des valeurs de puissance de 2
		 */
		void nbCoreChanged(int newNbCore);
	
	public:
	
		/*!
		 * \brief Constructeur
		 * \param parent : La fenêtre parente
		 */
		PromptSettings(QWidget* parent = 0);
		
		/*!
		 * \brief Destructeur
		 */
		~PromptSettings(void);
};

#endif
