#ifndef __GLOBAL_HPP__
#define __GLOBAL_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

// Nombres magiques pour le programme ( main.cpp )
const char APPLICATION_NAME[] = "Fractales";
const unsigned int APPLICATION_WIDTH = 640;
const unsigned int APPLICATION_HEIGHT = 480;

// Ceci est un maximum arbitraire
const int NB_MAX_CORE = 32;

enum ListInitFCT
{
	lifctPOINTALEATOIRE = 0,
	lifctPOINTIMAGE,
	lifctENDOFLIST					// Utile si l'on veut faire des parcours des énumarateurs ( doit toujours être en dernier) 
};

enum ListGeneratorFCT
{
	lgfctMANDELBROT = 0,
	lgfctBATEAUENFEU,
	lgfctTRICORN,
	lgfctJULIAN,
	lgfctNEWTON,
	lgfctNOVA,
	lgfctENDOFLIST					// Utile si l'on veut faire des parcours des énumarateurs ( doit toujours être en dernier) 
};

enum ListCurveFCT
{
	lcfctCLIFFORDATTRACTORS,
	lcfctCLIFFORDATTRACTORS2,
	lcfctENDOFLIST
};

enum ListAccumulateurFCT
{
	lafctACCUMULERSURLASEQUENCE = 0,
	lafctACCUMULERSURORIGINE,
	lafctENDOFLIST					// Utile si l'on veut faire des parcours des énumarateurs ( doit toujours être en dernier) 
};

struct Params
{
	ListInitFCT lifct;	/*!< Identifiant pour la fonction d'initialisation */
	ListGeneratorFCT lgfct;	/*!< Identifiant pour la fonction de generation */
	ListAccumulateurFCT lafct;	/*! Identifiant pour la fonction d'accumulation */

	unsigned int iWidth;	/*!< Largeur de l'image */
	unsigned int iHeight;	/*!< Hauteur de l'image */
	
	double zX;	/*!< Valeur réelle la plus petite de la zone complexe */
	double zY;	/*!< Valeur complexe la plus petite de la zone complexe */
	double zWidth;	/*!< Largeur de la zone complexe */
	double zHeight;	/*!< Hauteur de la zone complexe */
};

struct ParamsCurve
{
	ListCurveFCT lcfct;	/*!< Identifiant pour la fonction de generation */

	unsigned int nbPoints;	/*!< Nombre de points */
	
	double pX;				/*!< Point de départ */
	double pY;				/*!< Point de départ */
	
	double paramA;
	double paramB;
	double paramC;
	double paramD;

	unsigned int iWidth;	/*!< Largeur de l'image */
	unsigned int iHeight;	/*!< Hauteur de l'image */
	
	double zX;	/*!< Valeur réelle la plus petite de la zone complexe */
	double zY;	/*!< Valeur complexe la plus petite de la zone complexe */
	double zWidth;	/*!< Largeur de la zone complexe */
	double zHeight;	/*!< Hauteur de la zone complexe */
};

#endif
