/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

#include <QApplication>
#include <QTranslator>
#include <QLocale>
#include <QTime>

#include "Interface/MainWindow.hpp"
#include "global.hpp"

/*!
 * \file main.cpp
 * \brief Point d'entrée du programme. Démarre Qt et présente la fenêtre principale
 * \author Alexandre LAURENT
 * \version 1.0
 */

int main (int argc, char** argv)
{
	int* p = 0;
	delete p;
	QApplication app(argc,argv);
	QString locale = QLocale::system().name().section('_', 0, 0);
    QTranslator translator;
    
    translator.load(QString("Defi_Fractales_") + locale);
		
    app.installTranslator(&translator);

	
	qsrand(QTime::currentTime().msec());
	
	MainWindow mw(APPLICATION_NAME, APPLICATION_WIDTH, APPLICATION_HEIGHT);
	
	mw.show();
	
	app.exec();
	
	return 0;
}
