#ifndef __TYPES_HPP__
#define __TYPES_HPP__

/*
# Copyright (c) 2010 Alexandre LAURENT
#
# Permission is hereby granted, free of charge, to any person obtaining a copy
# of this software and associated documentation files (the "Software"), to deal
# in the Software without restriction, including without limitation the rights
# to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
# copies of the Software, and to permit persons to whom the Software is
# furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice shall be included in
# all copies or substantial portions of the Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
# AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
# OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
# THE SOFTWARE.
*/

/*! \struct generatorDefaultValues
 * \brief Va contenir les paramètres pour les fractales par défault
 */
typedef struct generatorDefaultValues
{
	const char* name;
	
	const ListInitFCT lifct;
	const ListAccumulateurFCT lafct;
	
	const double x;
	const double y;
	const double w;
	const double h;
	
}generatorDefaultValues;

const generatorDefaultValues generatorFCTString[lgfctENDOFLIST] =
{
	{ "Mandelbrot", lifctPOINTIMAGE, lafctACCUMULERSURORIGINE, -2., -2., 4., 4. },
	{ "Bateau en feu", lifctPOINTIMAGE, lafctACCUMULERSURORIGINE, -1.75, -.125, .25, .25 },
	{ "Tricorn", lifctPOINTIMAGE, lafctACCUMULERSURORIGINE, -2., -2., 4., 4. },
	{ "Julian", lifctPOINTIMAGE, lafctACCUMULERSURORIGINE, -2., -2., 4., 4. },
	{ "Newton", lifctPOINTIMAGE, lafctACCUMULERSURORIGINE, -10., -10., 20., 20. },
	{ "Nova", lifctPOINTIMAGE , lafctACCUMULERSURORIGINE, -1.5, -1.5, 3., 3. },
	//{ "Clifford attractors", -3., -3., 6., 6. },
};	/*! Les valeurs des fractales par default */

/*! \struct curveDefaultValues
 * \brief Va contenir les paramètres pour les courbes par défault
 */
typedef struct curveDefaultValues
{
	const char* name;
	
	const unsigned int nbPoints;
	
	const double paramA;
	const double paramB;
	const double paramC;
	const double paramD;
	
	const double pX;
	const double pY;
	
	const double x;
	const double y;
	const double w;
	const double h;
	
}curveDefaultValues;

const curveDefaultValues curveFCTString[lgfctENDOFLIST] =
{
	{ "CliffordAttractors", 1000, -1.4, 1.6, 1.0, 0.6,  0., 0., -3., -3., 6., 6. },
	{ "CliffordAttractors2", 1000, 1.7, 1.7, 1.2, 1.7, 0., 0., -3., -3., 6., 6. },
};	/*! Les valeurs des courbes par default */

#endif
