/**
	by	::	Adrabi Abderrahim
	License	::	The Artistic License
*/

//# constants
var zheight = zone.getZoneHeight();    //zone height
var zwidth  = zone.getZoneWidth();     //zone width
var iheight = zone.getImageHeight();   //image height
var iwidth  = zone.getImageWidth();    //image width
var minx    = zone.getX();             //min x in complex zone
var miny    = zone.getY();             //min y in complex zone
var startp  = zone.getStartPoint();    //thread start point
var inc     = zone.getIncrement();     //thread increment points by X
var itr     = zone.getIteration();     //thread iteration count
var zoom    = zone.getZoom();          //zoom
var viewx   = zone.getViewX();         //zoom view X
var viewy   = zone.getViewY();         //zoom view Y

//#
var MAX      = 32;
var itrCount = 0;
var y        = 0;
var rzoom    = zoom / ( iwidth < iheight ? iwidth : iheight );
var _red = 5, _blue = 5, _green = 5;

var __LIMIT__ = 10000;

var imagePoints = new Array( iwidth );
for( var _x = 0 ; _x < iwidth ; _x++ )
{
	imagePoints[ _x ] = new Array( iheight );
	for( var _y = 0 ; _y < iheight ; _y++ )
	{
		imagePoints[_x][_y] = 0 ;
	}
}

//# starting ...
while( itrCount < itr && !zone.cancel() )
{
    while( y < iheight && !zone.cancel() )
    {
        var x = startp;
        while( x < iwidth && !zone.cancel() )
        {

            var dx = minx + ( zwidth    * (( x + .5 ) * rzoom + viewx ) );
            var dy = miny + ( zheight   * (( y + .5 ) * rzoom + viewy ) );

			var points = new Array();
			var zx = 0.0, zy = 0.0, zx2 = 0.0, zy2 = 0.0, value = 0;
			
                    while (  (zx2 + zy2)  < 4.0 && value < __LIMIT__  && !zone.cancel() )
			{
		    	zy = 2.0 * zx * zy + dy;
      			zx = zx2 - zy2 + dx;
		        zx2 = zx * zx;
      			zy2 = zy * zy;
				points.push( [zx, zy] );
				value++;
		    }

			if( (zx2 + zy2) < 4.0 )
			{
				points = [];
			} 

            		for( var clx = 0 ; clx < points.length ; clx++ )
			{
				var tmpx = parseInt( ( ( ( points[clx][0] - minx ) / zwidth ) - viewx ) / rzoom ) ;
				var tmpy = parseInt( ( ( ( points[clx][1] - miny ) / zheight ) - viewy ) / rzoom );
				if(  tmpx >= 0 && tmpx < iwidth && tmpy >= 0 && tmpy < iheight )
				{
                                        imagePoints[tmpx][tmpy] += ( 256 * 256 * _red ) + ( 256 * _blue  ) + _green  ;
				}
			}
			
            //# increment X
            x += inc;
        }

		if( y % 4 == 0 )
		{
			zone.progress( y / 4 );
		}

        //# increment Y
        y += 1;

    }

    //# increment iteration by 1
    y = 0;
    itrCount++;
	//zone.sendSnapshot();
	//zone.beep();
}

for( var x = 0 ; x < iwidth ; x++ )
{
	zone.setPixels( x, imagePoints[x] );
}
