/**
	by	::	Adrabi Abderrahim
	License	::	The Artistic License
*/

//# constants
var zheight = zone.getZoneHeight();    //zone height
var zwidth  = zone.getZoneWidth();     //zone width
var iheight = zone.getImageHeight();   //image height
var iwidth  = zone.getImageWidth();    //image width
var minx    = zone.getX();             //min x in complex zone
var miny    = zone.getY();             //min y in complex zone
var startp  = zone.getStartPoint();    //thread start point
var inc     = zone.getIncrement();      //thread increment points by X
var zoom    = zone.getZoom();          //zoom
var viewx   = zone.getViewX();         //zoom view X
var viewy   = zone.getViewY();         //zoom view Y

// used *ONLY* for serialization
var lastY   = zone.getLastY();

//#
var MAX      = 512;
var y        = lastY;
var rzoom    = zoom / ( iwidth < iheight ? iwidth : iheight );

var colorMap = new Array();
for(var i = 0 ; i < MAX ; ++i )
{
	colorMap.push( waveSize( 380.0 + ( i * 400.0 / MAX) ) );
}

//# starting ...

while( y < iheight && !zone.cancel() )
{
	var x = startp;
        while( x < iwidth && !zone.cancel() )
        {

            var dx = minx + ( zwidth    * (( x + .5 ) * rzoom + viewx ) );
            var dy = miny + ( zheight   * (( y + .5 ) * rzoom + viewy ) );

            var value = mandel(dx, dy);
			
	
	if( value % MAX != 0 )
	{
	   zone.setPixel(x,y, colorMap[ value % MAX ] );
	}
			
            //# increment X
            x += inc;
        }

	if( y % 4 == 0 )
	{
		zone.progress( y / 4 );
	}

        //# increment Y
        y += 1;
		
}

zone.setLastXYI(0, y, 0);


function mandel(px,py) {
    var value = 0;
    var zx = 0.0, zy = 0.0,	//Z[n+1]
	zx_n = .0, zy_n = .0,	//Z[n]
       	zx2 = 0.0, zy2 = 0.0;
    	
    while (value < MAX && (zx2 + zy2) < 4. ) {
	zx_n = zx;
	zy_n = zy;

	zx2 = zx * zx;
 	zy2 = zy * zy;
 	zy = 2.0 * zx * zy;
 	zx = zx2 - zy2;

	zx2 = (zx * zx_n) - (zy * zy_n);
	zy2 = (zy * zx_n) + (zx * zy_n);

	zx = zx2 - ( zx_n + px ) ;
	zy = zy2 - ( zy_n + py );

      value++;
    }
    return value;
}

function waveSize(wave)
{
    var r = 0.0;
    var g = 0.0;
    var b = 0.0;

    if (wave >= 380.0 && wave <= 440.0) {
        r = -1.0 * (wave - 440.0) / (440.0 - 380.0);
        b = 1.0;
    } else if (wave >= 440.0 && wave <= 490.0) {
        g = (wave - 440.0) / (490.0 - 440.0);
        b = 1.0;
    } else if (wave >= 490.0 && wave <= 510.0) {
        g = 1.0;
        b = -1.0 * (wave - 510.0) / (510.0 - 490.0);
    } else if (wave >= 510.0 && wave <= 580.0) {
        r = (wave - 510.0) / (580.0 - 510.0);
        g = 1.0;
    } else if (wave >= 580.0 && wave <= 645.0) {
        r = 1.0;
        g = -1.0 * (wave - 645.0) / (645.0 - 580.0);
    } else if (wave >= 645.0 && wave <= 780.0) {
        r = 1.0;
    }

    var s = 1.0;
    if (wave > 700.0)
        s = 0.3 + 0.7 * (780.0 - wave) / (780.0 - 700.0);
    else if (wave <  420.0)
        s = 0.3 + 0.7 * (wave - 380.0) / (420.0 - 380.0);

    r = Math.pow(r * s, 0.2);
    g = Math.pow(g * s, 0.2);
    b = Math.pow(b * s, 0.2);
	
    return (65536 * parseInt(r * 255)) +  (256 * parseInt(g * 255)) + parseInt(b * 255);
}

