/**
 \brief AiFractal is a UI project code name for Fractal Generator (AiGenerator)
 \author Adrabi Abderrahim
 \date 2010-01-01
 \package AiFractals
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#include "aiconfig.hpp"

using namespace AiFractals;

AiConfig::AiConfig(QWidget * parent )
        :QDialog( parent )
{
    //~ create a tab widget and add a tools tabs

    m_tabs = new QTabWidget(this);
    m_tabs->setTabPosition(QTabWidget::West);

    AiConfigTools * tools = new AiConfigTools(m_tabs) ;
    AiConfigFractals * fractals = new AiConfigFractals(m_tabs);
    AiConfigZone * zone = new AiConfigZone(m_tabs);
    AiConfigGenerator * generator = new AiConfigGenerator(m_tabs);

    //~ tools tab
    tools->setObjectName( "tools" );
    fractals->setObjectName( "fractals" );
    zone->setObjectName( "zone" );
    generator->setObjectName( "generator" );

    this->connect( tools, SIGNAL(zoomIn()), this, SIGNAL(zoomIn()) );
    this->connect( tools, SIGNAL(zoomOut()), this, SIGNAL(zoomOut()) );
    this->connect( tools, SIGNAL(zoomArea(bool)), this, SIGNAL(zoomArea(bool)) );
    this->connect( tools, SIGNAL(horizontalMirror()), this, SIGNAL(horizontalMirror()) );
    this->connect( tools, SIGNAL(verticalMirror()), this, SIGNAL(verticalMirror()) );
    this->connect( tools, SIGNAL(clear()), this, SIGNAL(clear()) );
    this->connect( tools, SIGNAL(rotation(int)), this, SIGNAL(rotation(int)) );

    this->connect( fractals, SIGNAL(refreshItems()),this,SIGNAL(refreshItems()));
    this->connect( fractals, SIGNAL(debugFractal()),this,SIGNAL(debugFractal()));
    this->connect( fractals, SIGNAL(currentIndexChanged(int)),this,SIGNAL(currentIndexChanged(int)));

    this->connect( generator, SIGNAL(currentThreads(int)), this, SIGNAL(currentThreads(int)) );
    this->connect( generator, SIGNAL(firstCompositionMode(int)), this, SIGNAL(firstCompositionMode(int)) );
    this->connect( generator, SIGNAL(othersCompositionMode(int)), this, SIGNAL(othersCompositionMode(int)) );
    this->connect( generator, SIGNAL(runGenerator()), this, SIGNAL(runGenerator()) );
    this->connect( generator, SIGNAL(stopGenerator()), this, SIGNAL(stopGenerator()) );


    m_tabs->addTab( tools, tr("Tools") );

    //~ fractals tab
    m_tabs->addTab( fractals , tr("Fractals") );

    //~ complex zone tab
    m_tabs->addTab( zone , tr("Complex Zone") );

    //~ generator tab
    m_tabs->addTab( generator , tr("Generator") );
    
    QHBoxLayout * layout = new QHBoxLayout();
    layout->addWidget( m_tabs );
    this->setLayout( layout );
}

void AiConfig::closeEvent(QCloseEvent *event)
{
    emit closed();
}

void AiConfig::activeTab(int id)
{
    m_tabs->setCurrentIndex( id );
}

void AiConfig::enabledChilds(bool e)
{
    QWidget *tools = m_tabs->findChild< QWidget * >( "tools" );
    tools->setEnabled( e );
}

void AiConfig::addItems(const QStringList & items)
{
    AiConfigFractals * fractals = m_tabs->findChild< AiConfigFractals * >( "fractals" );
    fractals->addItems( items );
}

const QString AiConfig::item(const int index )
{
    AiConfigFractals * fractals = m_tabs->findChild< AiConfigFractals * >( "fractals" );
    return fractals->item( index );
}

const double AiConfig::getZoneWidth()   const
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    return zone->getZoneWidth();
}

void AiConfig::setZoneWidth( double w )
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    zone->setZoneWidth( w );
}

const double AiConfig::getZoneHeight()  const
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    return zone->getZoneHeight();
}

void AiConfig::setZoneHeight( double h )
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    zone->setZoneHeight( h );
}

const double AiConfig::getZoneMinX()    const
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    return zone->getZoneMinX();
}

void AiConfig::setZoneMinX( double x )
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    zone->setZoneMinX( x );
}

const double AiConfig::getZoneMinY()    const
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    return zone->getZoneMinY();
}

void AiConfig::setZoneMinY( double y )
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    zone->setZoneMinY( y );
}

const int AiConfig::getImageWidth()  const
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    return zone->getImageWidth();
}

void AiConfig::setImageWidth( int w )
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    zone->setImageWidth( w );
}

const int AiConfig::getImageHeight() const
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    return zone->getImageHeight();
}

void AiConfig::setImageHeight( int h )
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    zone->setImageHeight( h );
}

const int AiConfig::getIterations() const
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    return zone->getIterations();
}

void AiConfig::setIterations( int i )
{
    AiConfigZone * zone = m_tabs->findChild< AiConfigZone * >( "zone" );
    zone->setIterations( i );
}

void AiConfig::setThreadsNumber(int n)
{
    AiConfigGenerator * generator = this->findChild< AiConfigGenerator * >( "generator" );
    generator->setThreadsNumber( n );
}


void AiConfig::disableZoomArea()
{
    AiConfigTools *tools = m_tabs->findChild< AiConfigTools * >( "tools" );
    tools->disableZoomArea();
}

AiConfig::~AiConfig()
{
    if( m_tabs != NULL )
    {
        delete m_tabs;
    }
}
