/**
 \brief AiFractal is a UI project code name for Fractal Generator (AiGenerator)
 \author Adrabi Abderrahim
 \date 2010-01-02
 \package AiFractals
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#include "aiconfigzone.hpp"

using namespace AiFractals;

AiConfigZone::AiConfigZone(QWidget * parent)
        :QWidget( parent )
{
    //~ init
    QLabel * lblZoneWidth   = new QLabel( tr("Zone Width :") );
    QLabel * lblZoneHeight  = new QLabel( tr("Zone Height :") );
    QLabel * lblZoneMinX    = new QLabel( tr("Zone Min X :") );
    QLabel * lblZoneMinY    = new QLabel( tr("Zone Min Y :") );
    QLabel * lblImageWidth  = new QLabel( tr("Image Width (px) :") );
    QLabel * lblImageHeight = new QLabel( tr("Image Height (px) :") );
    QLabel * lblIterations  = new QLabel( tr("Iterations :") );

    m_zoneWidth             = new QDoubleSpinBox();
    m_zoneHeight            = new QDoubleSpinBox();
    m_zoneMinX              = new QDoubleSpinBox();
    m_zoneMinY              = new QDoubleSpinBox();
    m_imageWidth            = new QSpinBox();
    m_imageHeight           = new QSpinBox();
    m_iterations            = new QSpinBox();
    QVBoxLayout * layout = new QVBoxLayout();

    //~setup
    m_zoneWidth->setDecimals(9);
    m_zoneHeight->setDecimals(9);
    m_zoneMinX->setDecimals(9);
    m_zoneMinY->setDecimals(9);

    m_zoneWidth->setRange(-9999.,9999.);
    m_zoneHeight->setRange(-9999.,9999.);
    m_zoneMinX->setRange(-9999.,9999.);
    m_zoneMinY->setRange(-9999.,9999.);
    m_imageWidth->setRange(-9999,9999);
    m_imageHeight->setRange(-9999,9999);
    m_iterations->setRange(1,99);
    m_iterations->setMinimum( 1 );

    layout->addWidget( lblZoneWidth );
    layout->addWidget( m_zoneWidth );
    layout->addWidget( lblZoneHeight );
    layout->addWidget( m_zoneHeight );
    layout->addWidget( lblZoneMinX );
    layout->addWidget( m_zoneMinX );
    layout->addWidget( lblZoneMinY );
    layout->addWidget( m_zoneMinY );
    layout->addWidget( lblImageWidth );
    layout->addWidget( m_imageWidth );
    layout->addWidget( lblImageHeight );
    layout->addWidget( m_imageHeight );
    layout->addWidget( lblIterations );
    layout->addWidget( m_iterations );

    this->setLayout( layout );

}

const double AiConfigZone::getZoneWidth()   const
{
    return m_zoneWidth->value();
}

void AiConfigZone::setZoneWidth( double w )
{
    m_zoneWidth->setValue( w );
}

const double AiConfigZone::getZoneHeight()  const
{
    return m_zoneHeight->value();
}

void AiConfigZone::setZoneHeight( double h )
{
    m_zoneHeight->setValue( h );
}

const double AiConfigZone::getZoneMinX()    const
{
    return m_zoneMinX->value();
}

void AiConfigZone::setZoneMinX( double x )
{
    m_zoneMinX->setValue( x );
}

const double AiConfigZone::getZoneMinY()    const
{
    return m_zoneMinY->value();
}

void AiConfigZone::setZoneMinY( double y )
{
    m_zoneMinY->setValue( y );
}

const int AiConfigZone::getImageWidth()  const
{
    return m_imageWidth->value();
}

void AiConfigZone::setImageWidth( int w )
{
    m_imageWidth->setValue( w );
}

const int AiConfigZone::getImageHeight() const
{
    return m_imageHeight->value();
}

void AiConfigZone::setImageHeight( int h )
{
    m_imageHeight->setValue( h );
}

const int AiConfigZone::getIterations() const
{
    return m_iterations->value();
}

void AiConfigZone::setIterations( int i )
{
    m_iterations->setValue( i );
}

AiConfigZone::~AiConfigZone()
{
    if( m_zoneWidth != NULL )
    {
        delete m_zoneWidth;
    }
    if( m_zoneHeight != NULL )
    {
        delete m_zoneHeight;
    }
    if( m_zoneMinX != NULL )
    {
        delete m_zoneMinX;
    }
    if( m_zoneMinY != NULL )
    {
        delete m_zoneMinY;
    }
    if( m_imageWidth != NULL )
    {
        delete m_imageWidth;
    }
    if( m_imageHeight != NULL )
    {
        delete m_imageHeight;
    }
    if( m_iterations != NULL )
    {
        delete m_iterations;
    }
}
