/**
 \brief AiGenerator is a generator core
 \author Adrabi Abderrahim
 \date 2010-01-10
 \package AiGenerator
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#ifndef AITHREAD_HPP
#define AITHREAD_HPP

#include <QtGui>
#include <QtScript>

#include "aizone.hpp"

namespace AiGenerator
{
    /**
      \brief A custom class for creating a multi-threading (for fractals generation)
      \class AiThread
      \author Adrabi Abderrahim
      \date 2010-01-10
     */
    class AiThread : public QThread
    {
        Q_OBJECT

    public:
        /**
           \brief contructor with optional parent
           \param parent : thread parent ( default = 0 )
         */
        AiThread( QObject * parent = 0 );

        /**
          \brief destructor
         */
        ~AiThread();

        /**
          \brief making and creating a new complex zone for current thread
          \param x : min X point in complex zone ( default = .0 )
          \param y : min Y point in complex zone ( default = .0 )
          \param zoneWidth : a zone width ( default = .0 )
          \param zoneHeight : a zone height ( default = .0 )
          \param startPoint : a image start point for fractal generation ( default = 0 )
          \param increment : increment next image point by "defined number" ( default = 0 )
          \param iteration : iteration numbers for generation ( default = 0 )
          \param zoom : number of zoom view ( default = 1.0 )
          \param viewx : number of zoom view x ( default = 0.0 )
          \param viewy : number of zoom view y ( default = 0.0 )
         */
        void makeZone(double x , double y ,
            double zoneWidth , double zoneHeight ,
            int imageWidth , int imageHeight ,
            int startPoint, int increment , int iteration, double zoom = 1., double viewx = .0, double viewy = .0 );

        /**
          \brief set script file
          \param file : file name
         */
        void scriptFile( const QString & file );

        /**
          \brief start thread
         */
        void start();

        /**
          \brief stop thread
         */
        void stop();

        /**
          \brief set composition mode for current thread
          \param m : current thread composition mode
         */
        void mode( QPainter::CompositionMode m );

        /**
          \brief
         */
        AiZone * getZone();

        /**
          \brief
         */
        void setZone( AiZone & zone );

    signals:
        /**
          \brief signal fired within image generation is complited
          \param zone : cuurent thread zone
         */
        void completed( AiGenerator::AiZone * zone );

        /**
          \brief signal fired within progressbar value changed
          \param val : progress bar value
         */
        void progressStatus( int val );

        /**
          \brief send a snapshot to view
          \param zone : current complex zone
         */
        void snapshot( AiGenerator::AiZone * zone );

    protected:

        /**
          \brief running thread
         */
        void run();

    private:
        /**
          \brief current thread zone
         */
        AiZone m_zone;

        /**
          \brief current thread script
         */
        QString m_file;

    };
}
#endif // AITHREAD_HPP
