/**
 \brief AiGenerator is a generator core
 \author Adrabi Abderrahim
 \date 2010-01-10
 \package AiGenerator
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#include "aizone.hpp"

using namespace AiGenerator;

AiZone::AiZone( QObject * parent ,
            double x , double y ,
            double zoneWidth , double zoneHeight ,
            int imageWidth , int imageHeight ,
            int startPoint, int increment , int iteration ,
            double zoom, double viewx, double viewy)

    : QObject( parent ), m_x( x ), m_y( y ), m_zoneWidth( zoneWidth ), m_zoneHeight( zoneHeight ),
      m_imageWidth( imageWidth ), m_imageHeight( imageHeight ),
      m_startPoint( startPoint ), m_increment( increment ), m_iteration( iteration ),
      m_zoom( zoom ),  m_viewX( viewx ), m_viewY( viewy ),
      m_image( imageWidth, imageHeight, QImage::Format_RGB32 ),
      m_u( 0 ), m_v( 4101842887655102017LL ), m_w( 1 ),
      m_last_x(0), m_last_y(0), m_last_iteration(0)
{
    status = false ;
    m_image.fill(Qt::transparent);
}

AiZone::AiZone( const AiZone & zone )
{
    this->m_image = zone.m_image;
    this->m_imageHeight = zone.m_imageHeight;
    this->m_imageWidth = zone.m_imageWidth;
    this->m_increment = zone.m_increment;
    this->m_iteration = zone.m_iteration;
    this->m_startPoint = zone.m_startPoint;
    this->status = zone.status;
    this->m_x = zone.m_x;
    this->m_y = zone.m_y;
    this->m_zoneHeight = zone.m_zoneHeight;
    this->m_zoneWidth = zone.m_zoneWidth;
    this->m_zoom = zone.m_zoom;
    this->m_viewX = zone.m_viewX;
    this->m_viewY = zone.m_viewY;
    this->status = zone.status;
    this->m_last_iteration = zone.m_last_iteration;
    this->m_last_x = zone.m_last_x;
    this->m_last_y = zone.m_last_y;
}

QImage  & AiZone::image()
{
    return m_image;
}

double  AiZone::getX()
{
    return m_x;
}

double  AiZone::getY()
{
    return m_y;
}

double  AiZone::getZoneWidth()
{
    return m_zoneWidth;
}

double  AiZone::getZoneHeight()
{
    return m_zoneHeight;
}

int     AiZone::getImageWidth()
{
    return m_imageWidth ;
}

int     AiZone::getImageHeight()
{
    return m_imageHeight;
}

int     AiZone::getStartPoint()
{
    return m_startPoint;
}

int     AiZone::getIncrement()
{
    return m_increment;
}

int     AiZone::getIteration()
{
    return m_iteration;
}

unsigned int AiZone::getPixel(int x, int y)
{
    return m_image.pixel(x, y);
}

void    AiZone::setPixel(int x, int y, unsigned int rgb)
{
    m_image.setPixel(x,y,rgb);
}

void    AiZone::setPixel(int x, int y, int red, int green, int blue)
{
    m_image.setPixel(x,y, qRgb(red,green,blue) );
}

void    AiZone::setPixels( int line ,QList< int >  pix )
{
    uint *scanLine = reinterpret_cast<uint *>(m_image.scanLine( line ) );
    for ( int x = 0 ; x < pix.length() ; x++ )
    {
        *scanLine++ = pix[x];
    }
}

bool    AiZone::cancel()
{
    return status;
}

void    AiZone::progress(int val)
{
    emit progressStatus( val );
}

void AiZone::serialize( QDataStream & stream )
{
    stream  << m_image
            << m_imageHeight
            << m_imageWidth
            << m_increment
            << m_iteration
            << m_last_x
            << m_last_y
            << m_startPoint
            << m_u
            << m_v
            << m_viewX
            << m_viewY
            << m_w
            << m_x
            << m_y
            << m_zoneHeight
            << m_zoneWidth
            << m_zoom
            ;
}

void AiZone::deserialize( QDataStream & stream )
{
    stream  >> m_image
            >> m_imageHeight
            >> m_imageWidth
            >> m_increment
            >> m_iteration
            >> m_last_x
            >> m_last_y
            >> m_startPoint
            >> m_u
            >> m_v
            >> m_viewX
            >> m_viewY
            >> m_w
            >> m_x
            >> m_y
            >> m_zoneHeight
            >> m_zoneWidth
            >> m_zoom
            ;
    status = false;
}

AiZone & AiZone::operator = (const AiZone &zone)
{
    this->m_image = zone.m_image;
    this->m_imageHeight = zone.m_imageHeight;
    this->m_imageWidth = zone.m_imageWidth;
    this->m_increment = zone.m_increment;
    this->m_iteration = zone.m_iteration;
    this->m_startPoint = zone.m_startPoint;
    this->status = zone.status;
    this->m_x = zone.m_x;
    this->m_y = zone.m_y;
    this->m_zoneHeight = zone.m_zoneHeight;
    this->m_zoneWidth = zone.m_zoneWidth;
    this->m_zoom = zone.m_zoom;
    this->m_viewX = zone.m_viewX;
    this->m_viewY = zone.m_viewY;
    this->status = zone.status;
    this->m_last_iteration = zone.m_last_iteration;
    this->m_last_x = zone.m_last_x;
    this->m_last_y = zone.m_last_y;
    return *this;
}

double AiZone::getZoom()
{
    return m_zoom;
}

double AiZone::getViewX()
{
    return m_viewX;
}

double AiZone::getViewY()
{
    return m_viewY;
}

bool AiZone::valid(int x, int y)
{
    return m_image.valid(x, y);
}

void AiZone::sendSnapshot()
{
    emit snapshot( this );
}

void AiZone::beep()
{
    QApplication::beep();
}

void    AiZone::initRandom(unsigned long long j)
{
    m_u = j ^ m_v;
    generateUInt64();
    m_v = m_u;
    generateUInt64();
    m_w = m_v;
    generateUInt64();
}

unsigned long long AiZone::generateUInt64()
{
    m_u = m_u * 2862933555777941757LL + 7046029254386353087LL;
    m_v ^= m_v >> 17;
    m_v ^= m_v << 31;
    m_v ^= m_v >> 8;
    m_w = 4294957665U * ( m_w & 0xffffffff ) + ( m_w >> 32 );
    unsigned long long x = m_u ^ ( m_u << 21 );
    x ^= x >> 35; x ^= x << 4;
    return ( x + m_v ) ^ m_w;
}

double AiZone::generateDouble()
{
    return   5.42101086242752217E-20 * generateUInt64();
}

unsigned int AiZone::generateUInt32()
{
    return (unsigned int)generateUInt64();
}

int AiZone::getLastX() const
{
    return m_last_x;
}

int AiZone::getLastY() const
{
    return m_last_y;
}

int AiZone::getLastIteration() const
{
    return m_last_iteration;
}

void AiZone::setLastXYI(int x, int y, int i)
{
    m_last_x = x;
    m_last_y = y;
    m_last_iteration = i;
}
