/**
 \brief AiFractal is a UI project code name for Fractal Generator (AiGenerator)
 \author Adrabi Abderrahim
 \date 2009-12-18
 \package AiFractals
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#ifndef AIMAINWINDOW_HPP
#define AIMAINWINDOW_HPP

#include <QMainWindow>
#include <QtScript>
#include <QScriptEngineDebugger>

#include "../aimenubar/aimenubar.hpp"
#include "../aiviewerarea/aiviewerarea.hpp"
#include "../aitoolbar/aitoolbar.hpp"
#include "../aistatusbar/aistatusbar.hpp"
#include "../aiconfig/aiconfig.hpp"
#include "../aigenerator/aithread.hpp"
#include "../aiabout/aiabout.hpp"
#include "../aihelp/aihelp.hpp"
#include "../aiundodialog/aiundodialog.hpp"

namespace AiFractals
{
    /**
      \brief A main window for AiFractals
      \class AiMainWindow
      \author Adrabi Abderrahim
      \date 2009-12-18
     */
    class AiMainWindow : public QMainWindow
    {
        Q_OBJECT

    public:

        /**
          \brief default constructor
         */
        AiMainWindow();

        /**
          \brief destructor
         */
        ~AiMainWindow();

    private slots:
        /**
          \brief change check box status (checked/or no)
         */
        void checkedToolbox();

        /**
          \brief show or hide a tool box
         */
        void showToolbox(bool show);

        /**
          \brief slot for pening an image file
         */
        void fileOpen();

        /**
          \brief slot for saving an image file ( theoretically generated fractal=) )
         */
        void fileSave();

        /**
          \brief slot for saving an image as another name
         */
        void fileSaveAs();

        /**
          \brief slot for printing an image
         */
        void filePrint();

        /**
          \brief slot for screen clearing
         */
        void fileClear();

        /**
          \brief slot for quitting application
         */
        void fileQuit();

        /**
          \brief slot for zooming in an image
         */
        void zoomZoomIn();

        /**
          \brief slot for zooming out an image
         */
        void zoomZoomOut();

        /**
          \brief slot for fitting an image in window
         */
        void zoomFitInWindow();

        /**
          \brief slot for fitting an image to window
         */
        void zoomFitToWindow();

        /**
          \brief slot for zooming 1600\%
         */
        void zoom1600p();

        /**
          \brief slot for zooming 800\%
         */
        void zoom800p();

        /**
          \brief slot for zooming 400\%
         */
        void zoom400p();

        /**
          \brief slot for zooming 200\%
         */
        void zoom200p();

        /**
          \brief slot for zooming 100\%
         */
        void zoom100p();

        /**
          \brief slot for zooming 50\%
         */
        void zoom50p();

        /**
          \brief slot for zooming 25\%
         */
        void zoom25p();

        /**
          \brief slot for zooming 12.5\%
         */
        void zoom12_5p();

        /**
          \brief slot for zooming 6.25\%
         */
        void zoom6_25p();

        //~ Image
        /**
          \brief slot for horizontal mirror
         */
        void imageHorizontalMirror();

        /**
          \brief slot for virtical mirror
         */
        void imageVerticalMirror();

        /**
          \brief slot for Rotation 90
         */
        void imageRotation90();

        /**
          \brief slot for Rotation -90
         */
        void imageRotationNigative90();

        /**
          \brief slot for Rotation -180
         */
        void imageRotation180();

        //~ Generator
        /**
          \brief slot for running generator
         */
        void genRun();

        /**
          \brief slot for stoping generator
         */
        void genStop();

        /**
          \brief slot for showing a tool box "generator tab"
         */
        void genThreadsNumbers();

        /**
          \brief slot for showing a tool box "fractals tab"
         */
        void genChooseFractal();

        /**
          \brief slot for showing a tool box "complex zone"
         */
        void complexZone();

        /**
          \brief serialize threads saving storing it, for another usage =)
         */
        void serialize();

        /**
          \brief deserialize threads (zones) for generator
         */
        void deserialize();

        //~ Help
        /**
          \brief slot for showing help
         */
        void helpHelp();

        /**
          \brief slot for showing about me ;)
         */
        void helpAbout();

        /**
          \brief slot for button zoom-area
          \param for enabling zoom area
         */
        void toolsZoomArea(bool enable);

        /**
          \brief slot dial rotation (value changed)
          \param value : current value
         */
        void toolsRotation(int value);

        /**
            \brief slot for refreshing a fractals list
         */
        void refreshItems();

        /**
            \brief slot to get currentIndex in the combobox changed
            \param index : current index value
         */
        void currentIndexChanged ( int index );

        /**
            \brief slot for a fractals debugging script
         */
        void debugFractal();

        /**
          \brief slot for current threads number
          \param thread : threads number
         */
        void currentThreads(int thread);

        /**
          \brief slot for current first composition mode index
          \param val : current index value
         */
        void firstCompositionMode( int val );

        /**
          \brief slot for current others compisition mode index
          \brief int val : current index value
         */
        void othersCompositionMode( int val );

        /**
          \brief slot for running generator
         */
        void runGenerator();

        /**
          \brief slot for stoping generator
         */
        void stopGenerator();

        /**
          \brief slot for updating view with new image in complex zone
          \param zone : current zone from script
         */
        void completed( AiGenerator::AiZone * zone );

        /**
          \brief slot for updating view with new image in complex zone
          \brief evrey complited iteration
          \param zone : current zone from script
         */
        void snapshot( AiGenerator::AiZone * zone );

        /**
          \brief current params for new zone
          \param startx : start x in zoom zone
          \param strary : start y in zoom zone
          \param endx : end x in zoom zone
          \param endy : end y in zoom zone
         */
        void zoneZooming ( int startx, int starty, int endx, int endy );

        /**
          \brief enable and desable child's
          \param e : change child's enabling status
         */
        void enabledChilds(bool e);

        /**
          \brief undo
         */
        void undo();

    private:
        /**
          \brief pointer for configuration dialogbox (toolbox)
         */
        AiConfig * m_config;

        /**
          \brief pointer for toolbar
         */
        AiToolBar * m_toolbar;

        /**
          \brief pointer for menubar
         */
        AiMenuBar * m_menuBar;

        /**
          \brief pointer for statusbar
         */
        AiStatusBar * m_statusbar;

        /**
          \brief pointer for viewer-area
         */
        AiViewerArea * m_view ;

        /**
          \brief poiter for history dialog
         */
        AiUndoDialog * m_undoDialog;
        /**
          \brief save file name,
         */
        QString m_saveFile;

        /**
          \brief fractal select index
         */
        int m_selectedFractalIndex;

        /**
          \brief current threads number
         */
        int m_currentThreadsNumber;

        /**
          \brief threads number in staring
         */
        int m_startedThreads;

        /**
          \brief first composition mode index
         */
        QPainter::CompositionMode m_firstCompositionModeIndex;

        /**
          \brief others composition mode index
         */
        QPainter::CompositionMode m_othersCompositionModeIndex;

        /**
          \brief threads vector for setting and managing list of threads
         */
        QVector<AiGenerator::AiThread *> m_threads;

        /**
          \brief get a composition mode
          \param index : composition mode index
         */
        QPainter::CompositionMode forgeCompositionMode( int index );

        /**
          \brief stoge images by start ID
         */
        QVector<QImage> m_storage;

        /**
          \brief zoom view X value
         */
        double m_viewX;

        /**
          \brief zoom view Y value
         */
        double m_viewY;

        /**
          \brief zoom value
         */
        double m_zoom;

        /**
          \brief for not cleaning a threads after be compilted =)
            and  storing current data for serialization (GOD MODE xD)
         */
        bool m_serialize;
    };
}
#endif // AIMAINWINDOW_HPP
