/**
 \brief AiFractal is a UI project code name for Fractal Generator (AiGenerator)
 \author Adrabi Abderrahim
 \date 2009-12-18
 \package AiFractals
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#include "aimenubar.hpp"

using namespace AiFractals;

AiMenuBar::AiMenuBar( QWidget * parent)
        :QMenuBar( parent )
{
    //~File
    {
        QMenu * fileMenu = this->addMenu( tr("&File") );
        fileMenu->setObjectName( "fileMenu" );
        {
            QAction * fileOpen= new QAction( tr( "&Open" ), this );
                      fileOpen->setIcon( QIcon( tr(":/png/open") ) );
                      fileOpen->setShortcut(QKeySequence::New);
                      fileOpen->setStatusTip( tr("Open Image") );
                      this->connect( fileOpen, SIGNAL(triggered()), this, SIGNAL(fileOpen()) );

            QAction * fileSave= new QAction( tr( "&Save" ), this );
                      fileSave->setObjectName( "fileSave" );
                      fileSave->setIcon( QIcon( tr(":/png/save") ) );
                      fileSave->setShortcut(QKeySequence::Save);
                      fileSave->setStatusTip( tr("Save Image") );
                      this->connect( fileSave, SIGNAL(triggered()), this, SIGNAL(fileSave()) );

            QAction * fileSaveAs= new QAction( tr( "Save &As" ), this );
                      fileSaveAs->setObjectName( "fileSaveAs" );
                      fileSaveAs->setIcon( QIcon( tr(":/png/saveas") ) );
                      fileSaveAs->setShortcut(QKeySequence::SaveAs);
                      fileSaveAs->setStatusTip( tr("Save as...") );
                      this->connect( fileSaveAs, SIGNAL(triggered()), this, SIGNAL(fileSaveAs()) );

            QAction * filePrint= new QAction( tr( "&Print" ), this );
                      filePrint->setObjectName( "filePrint" );
                      filePrint->setIcon( QIcon( tr(":/png/print") ) );
                      filePrint->setShortcut(QKeySequence::Print);
                      filePrint->setStatusTip( tr("Print") );
                      this->connect( filePrint, SIGNAL(triggered()), this, SIGNAL(filePrint()) );

            QAction * fileClear= new QAction( tr( "&Clear" ), this );
                      fileClear->setObjectName( "fileClear" );
                      fileClear->setIcon( QIcon( tr(":/png/clear") ) );
                      fileClear->setStatusTip( tr("Clear") );
                      this->connect( fileClear, SIGNAL(triggered()), this, SIGNAL(fileClear()) );

            QAction * fileQuit= new QAction( tr( "&Quit" ), this );
                      fileQuit->setIcon( QIcon( tr(":/png/quit") ) );
                      fileQuit->setShortcut(QKeySequence(tr("Ctrl+Q")));
                      fileQuit->setStatusTip( tr("Quit") );
                      this->connect( fileQuit, SIGNAL(triggered()), this, SIGNAL(fileQuit()) );

            fileMenu->addAction( fileOpen );
            fileMenu->addSeparator();
            fileMenu->addAction( fileSave );
            fileMenu->addAction( fileSaveAs );
            fileMenu->addSeparator();
            fileMenu->addAction( filePrint );
            fileMenu->addSeparator();
            fileMenu->addAction( fileClear );
            fileMenu->addSeparator();
            fileMenu->addAction( fileQuit );
        }
    }


    //~ Zoom
    {
        QMenu * zoomMenu = this->addMenu( tr("&Zoom") );
        zoomMenu->setObjectName( "zoomMenu" );
        {
            QAction * zoomZoomIn= new QAction( tr( "Zoom In" ), this );
                      zoomZoomIn->setIcon( QIcon( tr(":/png/zoom-in") ) );
                      zoomZoomIn->setShortcut(QKeySequence::ZoomIn);
                      zoomZoomIn->setStatusTip( tr("Zoom In") );
                      this->connect( zoomZoomIn, SIGNAL(triggered()), this, SIGNAL(zoomZoomIn()) );

            QAction * zoomZoomOut= new QAction( tr( "Zoom Out" ), this );
                      zoomZoomOut->setIcon( QIcon( tr(":/png/zoom-out") ) );
                      zoomZoomOut->setShortcut(QKeySequence::ZoomOut);
                      zoomZoomOut->setStatusTip( tr("Zoom Out") );
                      this->connect( zoomZoomOut, SIGNAL(triggered()), this, SIGNAL(zoomZoomOut()) );

            QAction * zoomFitInWindow= new QAction( tr( "Fit in window" ), this );
                      zoomFitInWindow->setIcon( QIcon( tr(":/png/zoom-fit") ) );
                      zoomFitInWindow->setStatusTip( tr("Fit in window") );
                      this->connect( zoomFitInWindow, SIGNAL(triggered()), this, SIGNAL(zoomFitInWindow()) );

            QAction * zoomFitToWindow= new QAction( tr( "Fit to window" ), this );
                      zoomFitToWindow->setIcon( QIcon( tr(":/png/fit-zoom") ) );
                      zoomFitToWindow->setStatusTip( tr("Fit to window") );
                      this->connect( zoomFitToWindow, SIGNAL(triggered()), this, SIGNAL(zoomFitToWindow()) );

            QAction * zoom1600p= new QAction( tr( "Zoom 1600%" ), this );;
                      zoom1600p->setStatusTip( tr("Zoom 1600%") );
                      this->connect( zoom1600p, SIGNAL(triggered()), this, SIGNAL(zoom1600p()) );

            QAction * zoom800p= new QAction( tr( "Zoom 800%" ), this );
                      zoom800p->setStatusTip( tr("Zoom 800%") );
                      this->connect( zoom800p, SIGNAL(triggered()), this, SIGNAL(zoom800p()) );

            QAction * zoom400p= new QAction( tr( "Zoom 400%" ), this );
                      zoom400p->setStatusTip( tr("Zoom 400%") );
                      this->connect( zoom400p, SIGNAL(triggered()), this, SIGNAL(zoom400p()) );

            QAction * zoom200p= new QAction( tr( "Zoom 200%" ), this );
                      zoom200p->setStatusTip( tr("Zoom 200%") );
                      this->connect( zoom200p, SIGNAL(triggered()), this, SIGNAL(zoom200p()) );

            QAction * zoom100p= new QAction( tr( "Zoom 100%" ), this );
                      zoom100p->setStatusTip( tr("Zoom 100%") );
                      this->connect( zoom100p, SIGNAL(triggered()), this, SIGNAL(zoom100p()) );

            QAction * zoom50p= new QAction( tr( "Zoom 50%" ), this );
                      zoom50p->setStatusTip( tr("Zoom 50%") );
                      this->connect( zoom50p, SIGNAL(triggered()), this, SIGNAL(zoom50p()) );

            QAction * zoom25p= new QAction( tr( "Zoom 25%" ), this );
                      zoom25p->setStatusTip( tr("Zoom 25%") );
                      this->connect( zoom25p, SIGNAL(triggered()), this, SIGNAL(zoom25p()) );

            QAction * zoom12_5p= new QAction( tr( "Zoom 12.5" ), this );
                      zoom12_5p->setStatusTip( tr("Zoom 12.5%") );
                      this->connect( zoom12_5p, SIGNAL(triggered()), this, SIGNAL(zoom12_5p()) );

            QAction * zoom6_25p= new QAction( tr( "Zoom 6.25" ), this );
                      zoom6_25p->setStatusTip( tr("Zoom 6.25%") );
                      this->connect( zoom6_25p, SIGNAL(triggered()), this, SIGNAL(zoom6_25p()) );

            zoomMenu->addAction( zoomZoomIn );
            zoomMenu->addAction( zoomZoomOut );
            zoomMenu->addSeparator();
            zoomMenu->addAction( zoomFitInWindow );
            zoomMenu->addAction( zoomFitToWindow );
            zoomMenu->addSeparator();
            zoomMenu->addAction( zoom1600p );
            zoomMenu->addAction( zoom800p );
            zoomMenu->addAction( zoom400p );
            zoomMenu->addAction( zoom200p );
            zoomMenu->addAction( zoom100p );
            zoomMenu->addAction( zoom50p );
            zoomMenu->addAction( zoom25p );
            zoomMenu->addAction( zoom12_5p );
            zoomMenu->addAction( zoom6_25p );
        }
    }


    //~ Image
    {
        QMenu * imageMenu = this->addMenu( tr("&Image") );
        imageMenu->setObjectName( "imageMenu" );
        {
            QAction * imageHorizontalMirror= new QAction( tr( "Horizontal Mirror" ), this );
                      imageHorizontalMirror->setIcon( QIcon( tr(":/png/d+180") ) );
                      imageHorizontalMirror->setStatusTip( tr("Horizontal Mirror") );
                      this->connect( imageHorizontalMirror, SIGNAL(triggered()), this, SIGNAL(imageHorizontalMirror()) );

            QAction * imageVerticalMirror= new QAction( tr( "Vertical Mirror" ), this );
                      imageVerticalMirror->setIcon( QIcon( tr(":/png/d-90") ) );
                      imageVerticalMirror->setStatusTip( tr("Vertical Mirror") );
                      this->connect( imageVerticalMirror, SIGNAL(triggered()), this, SIGNAL(imageVerticalMirror()) );

            QAction * imageRotation90= new QAction( tr( "Rotation 90" ), this );
                      imageRotation90->setIcon( QIcon( tr(":/png/d+90") ) );
                      imageRotation90->setStatusTip( tr("Rotation 90") );
                      this->connect( imageRotation90, SIGNAL(triggered()), this, SIGNAL(imageRotation90()) );

            QAction * imageRotationNigative90= new QAction( tr( "Rotation -90" ), this );
                      imageRotationNigative90->setIcon( QIcon( tr(":/png/d-90") ) );
                      imageRotationNigative90->setStatusTip( tr("Rotation -90") );
                      this->connect( imageRotationNigative90, SIGNAL(triggered()), this, SIGNAL(imageRotationNigative90()) );

            QAction * imageRotation180= new QAction( tr( "Rotation 180" ), this );
                      imageRotation180->setIcon( QIcon( tr(":/png/d+180") ) );
                      imageRotation180->setStatusTip( tr("Rotation 180") );
                      this->connect( imageRotation180, SIGNAL(triggered()), this, SIGNAL(imageRotation180()) );

            imageMenu->addAction( imageHorizontalMirror );
            imageMenu->addAction( imageVerticalMirror );
            imageMenu->addSeparator();
            imageMenu->addAction( imageRotation90 );
            imageMenu->addAction( imageRotationNigative90 );
            imageMenu->addAction( imageRotation180 );
        }
    }


    //~ Generator
    {
        QMenu * generatorMenu = this->addMenu( tr("&Complex Zone") );
        {
            QAction * genRun= new QAction( tr( "Run" ), this );
                      genRun->setIcon( QIcon( tr(":/png/run") ) );
                      genRun->setStatusTip( tr("Run") );
                      this->connect( genRun, SIGNAL(triggered()), this, SIGNAL(genRun()) );

            QAction * genStop= new QAction( tr( "Stop" ), this );
                      genStop->setIcon( QIcon( tr(":/png/stop") ) );
                      genStop->setStatusTip( tr("Stop") );
                      this->connect( genStop, SIGNAL(triggered()), this, SIGNAL(genStop()) );

            QAction * genThreadsNumbers= new QAction( tr( "Threads" ), this );
                      genThreadsNumbers->setIcon( QIcon( tr(":/png/threads") ) );
                      genThreadsNumbers->setStatusTip( tr("Threads") );
                      this->connect( genThreadsNumbers, SIGNAL(triggered()), this, SIGNAL(genThreadsNumbers()) );

            QAction * genChooseFractal= new QAction( tr( "Fractals" ), this );
                      genChooseFractal->setIcon( QIcon( tr(":/png/fractals") ) );
                      genChooseFractal->setStatusTip( tr("Fractals") );
                      this->connect( genChooseFractal, SIGNAL(triggered()), this, SIGNAL(genChooseFractal()) );

            QAction * complexZone= new QAction( tr( "Zone" ), this );
                      complexZone->setIcon( QIcon( tr(":/png/complex") ) );
                      complexZone->setStatusTip( tr("Zone") );
                      this->connect( complexZone, SIGNAL(triggered()), this, SIGNAL(complexZone()) );

            QAction * serialize= new QAction( tr( "Serialize" ), this );
                      serialize->setIcon( QIcon( tr(":/png/serialize") ) );
                      serialize->setStatusTip( tr("Serialize") );
                      this->connect( serialize, SIGNAL(triggered()), this, SIGNAL(serialize()) );

            QAction * deserialize= new QAction( tr( "Deserialize" ), this );
                      deserialize->setIcon( QIcon( tr(":/png/deserialize") ) );
                      deserialize->setStatusTip( tr("Deserialize") );
                      this->connect( deserialize, SIGNAL(triggered()), this, SIGNAL(deserialize()) );

            generatorMenu->addAction( genRun );
            generatorMenu->addAction( genStop );
            generatorMenu->addSeparator();
            generatorMenu->addAction( genThreadsNumbers );
            generatorMenu->addAction( genChooseFractal );
            generatorMenu->addSeparator();
            generatorMenu->addAction( complexZone );
            generatorMenu->addSeparator();
            generatorMenu->addAction( serialize );
            generatorMenu->addAction( deserialize );

        }
    }

    //~ Help
    {
        QMenu * helpMenu = this->addMenu( tr("&Help") );
        {
             QAction * helpHelp = new QAction( tr( "Help" ), this );
                       helpHelp->setIcon( QIcon( tr(":/png/help") ) );
                       helpHelp->setStatusTip( tr("Help!") );
                       this->connect( helpHelp, SIGNAL(triggered()), this, SIGNAL(helpHelp()) );

             QAction * helpAbout = new QAction( tr( "About" ), this );
                       helpAbout->setIcon( QIcon( tr(":/png/about") ) );
                       helpAbout->setStatusTip( tr("About") );
                       this->connect( helpAbout, SIGNAL(triggered()), this, SIGNAL(helpAbout()) );

            helpMenu->addAction( helpHelp );
            helpMenu->addSeparator();
            helpMenu->addAction( helpAbout );
        }
    }

}

void AiMenuBar::enabledChilds(bool e)
{
    //~ file menu
    {
        QAction * fileSave  = this->findChild< QAction * >( "fileSave");
        QAction * fileSaveAs= this->findChild< QAction * >( "fileSaveAs");
        QAction * filePrint = this->findChild< QAction * >( "filePrint");
        QAction * fileClear = this->findChild< QAction * >( "fileClear");

        fileSave->setEnabled    ( e );
        fileSaveAs->setEnabled  ( e );
        filePrint->setEnabled   ( e );
        fileClear->setEnabled   ( e );
    }

    //~ zoom menu
    {
        QMenu * zoomMenu = this->findChild< QMenu * >( "zoomMenu" ) ;
        zoomMenu->setEnabled    ( e );
    }

    //~ image menu
    {
        QMenu * imageMenu = this->findChild< QMenu * >( "imageMenu" ) ;
        imageMenu->setEnabled   ( e );
    }
}
