/**
 \brief AiFractal is a UI project code name for Fractal Generator (AiGenerator)
 \author Adrabi Abderrahim
 \date 2009-12-18
 \package AiFractals
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#ifndef AIMENUBAR_HPP
#define AIMENUBAR_HPP

#include <QtGui>

namespace AiFractals
{
    /**
      \brief A custom class for menubar
      \class AiMenuBar
      \author Adrabi Abderrahim
      \date 2009-12-18
     */
    class AiMenuBar : public QMenuBar
    {
        Q_OBJECT

    public:
        /**
          \brief constructor with optional parent
          \param parent : a widget parent ( default = 0 )
         */
        AiMenuBar( QWidget * parent = 0 );

        /**
          \brief enable and desable child's
          \param e : enable child's ( for supporting *BAD* users manipulation =) Oops! )
         */
        void enabledChilds(bool e);

    signals:
        //~File
        /**
          \brief signal emitted whenever image file opening
         */
        void fileOpen();

        /**
          \brief signal emitted whenever image file saving
         */
        void fileSave();

        /**
          \brief signal emitted whenever image file saving in another place or deferent name
         */
        void fileSaveAs();

        /**
          \brief signal emitted whenever image printing
         */
        void filePrint();

        /**
          \brief signal emitted whenever AiView clearing
         */
        void fileClear();

        /**
          \brief signal emitted for quitting AiMainWindow
         */
        void fileQuit();

        //~ Zoom

        /**
          \brief signal emitted whenever image zooming in
         */
        void zoomZoomIn();

        /**
          \brief signal emitted whenever image zooming out
         */
        void zoomZoomOut();

        /**
          \brief signal emitted whenever image fit in window
         */
        void zoomFitInWindow();

        /**
          \brief signal emitted whenever image to Window
         */
        void zoomFitToWindow();

        /**
          \brief signal emitted whenever image zooming 1600\%
         */
        void zoom1600p();

        /**
          \brief signal emitted whenever image zooming 800\%
         */
        void zoom800p();

        /**
          \brief signal emitted whenever image zooming 400\%
         */
        void zoom400p();

        /**
          \brief signal emitted whenever image zooming 200\%
         */
        void zoom200p();

        /**
          \brief signal emitted whenever image zooming 100\%
         */
        void zoom100p();

        /**
          \brief signal emitted whenever image zooming 50\%
         */
        void zoom50p();

        /**
          \brief signal emitted whenever image zooming 25\%
         */
        void zoom25p();

        /**
          \brief signal emitted whenever image zooming 12.5\%
         */
        void zoom12_5p();

        /**
          \brief signal emitted whenever image zooming 6.25\%
         */
        void zoom6_25p();

        //~ Image
        /**
          \brief signal emitted whenever image horizontal mirror
         */
        void imageHorizontalMirror();

        /**
          \brief signal emitted whenever image virtical mirror
         */
        void imageVerticalMirror();

        /**
          \brief signal emitted whenever image Rotation 90
         */
        void imageRotation90();

        /**
          \brief signal emitted whenever image Rotation -90
         */
        void imageRotationNigative90();

        /**
          \brief signal emitted whenever image Rotation -180
         */
        void imageRotation180();

        //~ Generator
        /**
          \brief signal emitted whenever generator running
         */
        void genRun();

        /**
          \brief signal emitted whenever generator stoping
         */
        void genStop();

        /**
          \brief signal emitted whenever setting a threads numbers
         */
        void genThreadsNumbers();

        /**
          \brief signal emitted whenever choosing a fractals
         */
        void genChooseFractal();

        /**
          \brief signal emitted whenever setting a complex zone information
         */
        void complexZone();

        /**
          \brief serialize threads saving storing it, for another usage =)
         */
        void serialize();

        /**
          \brief deserialize threads (zones) for generator
         */
        void deserialize();
        //~ Help
        /**
          \brief signal emitted whenever helping
         */
        void helpHelp();

        /**
          \brief signal emitted whenever about me ;)
         */
        void helpAbout();
    };
}
#endif // AIMENUBAR_HPP
