/**
 \brief AiFractal is a UI project code name for Fractal Generator (AiGenerator)
 \author Adrabi Abderrahim
 \date 2009-12-15
 \package AiFractals
 \page License
    \paragraph <The Artistic License>
    The intent of this document is to state the conditions under which a Package may be copied, such that the Copyright Holder maintains some semblance of artistic control over the development of the package, while giving the users of the package the right to use and distribute the Package in a more-or-less customary fashion, plus the right to make reasonable modifications.

    Definitions:
    "Package" refers to the collection of files distributed by the Copyright Holder, and derivatives of that collection of files created through textual modification.
    "Standard Version" refers to such a Package if it has not been modified, or has been modified in accordance with the wishes of the Copyright Holder.
    "Copyright Holder" is whoever is named in the copyright or copyrights for the package.
    "You" is you, if you're thinking about copying or distributing this Package.
    "Reasonable copying fee" is whatever you can justify on the basis of media cost, duplication charges, time of people involved, and so on. (You will not be required to justify it to the Copyright Holder, but only to the computing community at large as a market that must bear the fee.)
    "Freely Available" means that no fee is charged for the item itself, though there may be fees involved in handling the item. It also means that recipients of the item may redistribute it under the same conditions they received it.

    1. You may make and give away verbatim copies of the source form of the Standard Version of this Package without restriction, provided that you duplicate all of the original copyright notices and associated disclaimers.
    2. You may apply bug fixes, portability fixes and other modifications derived from the Public Domain or from the Copyright Holder. A Package modified in such a way shall still be considered the Standard Version.
    3. You may otherwise modify your copy of this Package in any way, provided that you insert a prominent notice in each changed file stating how and when you changed that file, and provided that you do at least ONE of the following:
        a) place your modifications in the Public Domain or otherwise make them Freely Available, such as by posting said modifications to Usenet or an equivalent medium, or placing the modifications on a major archive site such as ftp.uu.net, or by allowing the Copyright Holder to include your modifications in the Standard Version of the Package.
        b) use the modified Package only within your corporation or organization.
        c) rename any non-standard executables so the names do not conflict with standard executables, which must also be provided, and provide a separate manual page for each non-standard executable that clearly documents how it differs from the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    4. You may distribute the programs of this Package in object code or executable form, provided that you do at least ONE of the following:
        a) distribute a Standard Version of the executables and library files, together with instructions (in the manual page or equivalent) on where to get the Standard Version.
        b) accompany the distribution with the machine-readable source of the Package with your modifications.
        c) accompany any non-standard executables with their corresponding Standard Version executables, giving the non-standard executables non-standard names, and clearly documenting the differences in manual pages (or equivalent), together with instructions on where to get the Standard Version.
        d) make other distribution arrangements with the Copyright Holder.

    5. You may charge a reasonable copying fee for any distribution of this Package. You may charge any fee you choose for support of this Package. You may not charge a fee for this Package itself. However, you may distribute this Package in aggregate with other (possibly commercial) programs as part of a larger (possibly commercial) software distribution provided that you do not advertise this Package as a product of your own.
    6. The scripts and library files supplied as input to or produced as output from the programs of this Package do not automatically fall under the copyright of this Package, but belong to whomever generated them, and may be sold commercially, and may be aggregated with this Package.
    7. C or perl subroutines supplied by you and linked into this Package shall not be considered part of this Package.
    8. The name of the Copyright Holder may not be used to endorse or promote products derived from this software without specific prior written permission.
    9. THIS PACKAGE IS PROVIDED "AS IS" AND WITHOUT ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.

    The End

 */

#ifndef AIVIEW_HPP
#define AIVIEW_HPP

#include <QtGui>

#include "aicommand/aicommand.hpp"
//~

namespace AiFractals
{
    /**
      \brief A custom class for creating an view image widget
      \class AiView
      \author Adrabi Abderrahim
      \date 2009-12-15
     */
    class AiView : public QWidget
    {
      Q_OBJECT
        
    public:
        /**
          \brief contructor with optional parent
          \param parent : widget parent ( default = 0 )
         */
        AiView(QWidget * parent = 0);

        /**
          \brief destructor
         */
        ~AiView();

        /**
          \brief updating view
         */
        void makeUpdate();

        /**
          \brief updating view by using a binary image (bytes from QImage)
          \param image : image byes
          \param undo : allow to add image to undo framework
         */
        void makeUpdate( QImage & image, bool undo );

        /**
          \brief updating view from reading a physical image (image path)
          \param fileName : file name path
         */
        void makeUpdate( QString & fileName );

        /**
          \brief updating view by using a binary image from undo command
          \param image : image byes
         */
        void makeUndoUpdate( QImage & image );

        /**
          \brief retate image in view by x
          \param r : rotation degree
         */
        void retate( qreal r );

        /**
          \brief scale image/ change image size
          \param xs : scale x image by qreal
          \param xy : scale y image by qreal
         */
        void scale( qreal sx, qreal sy );

        /**
          \brief save view image as file
          \param fileName : file path
         */
        void saveAs( QString & fileName );

        /**
          \brief current view image
         */
        QImage & image();

        /**
          \brief check if screen is empty no image loaded
          \return bool
         */
        const bool emptyScreen();

        /**
          \brief get custom scale X
          \return qreal
         */
        const qreal getScaleX() const;

        /**
          \brief get custom scale Y
          \return qreal
         */
        const qreal getScaleY() const;

        /**
          \brief clear scale and set current scale x,y as defauts
         */
        void clearScale();

        /**
          \brief get custion retation
          \return qreal
         */
        const qreal getRetation() const;

        /**
          \brief get loaded or generated image width
          \return int
         */
        const int getImageWidth();

        /**
          \brief get loaded or generated image height
          \return int
         */
        const int getImageHeight();

        /**
          \brief print an image
         */
        void print();

        /**
          \brief clear screen and set image to null or empty
         */
        void clear();

        /**
          \brief fill image to window size
         */
        void fillToWindow();

        /**
          \brief fill image in window
         */
        void fillInWindow();

        /**
          \brief stack of undo framework
         */
        QUndoStack * stack;

    public slots:
        /**
          \brief slot for enabling zooming area
          \param enable : enabling area zooming
         */
        void zooming(bool enable);

    signals:
        /**
          \brief signal sent within zone zomming is actived
          \param startx : start x area zoom
          \param starty : start y area zoom
          \param endx : end x area zoom
          \param endy : end y area zoom
         */
        void zoneZooming( int startx, int starty, int endx, int endy );

        /**
          \brief enable and desable child's
          \param e : change child's enabling status
         */
        void enabledChilds(bool e);
    protected:
        /**
          \param event : Qt paint event
         */
        void paintEvent ( QPaintEvent * event );

        /**
          \param event : Qt mouse event
         */
        void mouseMoveEvent ( QMouseEvent * event );

        /**
          \param event : Qt mouse event
         */
        void mousePressEvent ( QMouseEvent * event );

        /**
          \param event : Qt mouse event
         */
        void mouseReleaseEvent ( QMouseEvent * event );
    private:

        /**
          \brief get a new width for view
          \return int
         */
        int widthView(int w);

        /**
          \brief get a new height for view
          \return int
         */
        int heightView(int h);

        /**
          \brief main image for view
         */
        QImage m_image;

        /**
          \brief custom scale X
         */
        qreal m_scaleX;

        /**
          \brief custom scale Y
         */
        qreal m_scaleY;

        /**
          \brief allow scalling
         */
        bool m_scale;

        /**
          \brief clear current scale x,y
         */
        bool m_clearScale;

        /**
          \brief custom retation
         */
        qreal m_retation;

        /**
          \brief allow to image retation
         */
        bool m_canRetate;

        /**
          \brief allow zooming area
         */
        bool m_isZooming;

        /**
          \brief start x area zooming
         */
        int m_startX;

        /**
          \brief start y area zooming
         */
        int m_startY;

        /**
          \brief end x area zooming
         */
        int m_endX;

        /**
          \brief end y area zooming
         */
        int m_endY;

        /**
          \brief enable to fill image to window size
         */
        bool m_fill2Win;

    };
}
#endif // AIVIEW_HPP
