/**
	by	::	Adrabi Abderrahim
	License	::	The Artistic License
*/

//# constants
var zheight = zone.getZoneHeight();    //zone height
var zwidth  = zone.getZoneWidth();     //zone width
var iheight = zone.getImageHeight();   //image height
var iwidth  = zone.getImageWidth();    //image width
var minx    = zone.getX();             //min x in complex zone
var miny    = zone.getY();             //min y in complex zone
var startp  = zone.getStartPoint();    //thread start point
var inc     = zone.getIncrement();     //thread increment points by X
var itr     = zone.getIteration();     //thread iteration count
var zoom    = zone.getZoom();          //zoom
var viewx   = zone.getViewX();         //zoom view X
var viewy   = zone.getViewY();         //zoom view Y

//Colors
var __RED	= 8000;
var __GREEN	= 2000;
var __BLUE	= 500;

var __MAXRED	= 0;
var __MAXGREEN	= 0;
var __MAXBLUE	= 0;

//Arrays
var red		= new Array(iwidth);
var green	= new Array(iwidth);
var blue	= new Array(iwidth);

//Initialization
for( var x = 0 ; x < iwidth && !zone.cancel() ; x++ )
{
	red[x]		= new Array( iheight );
	green[x]	= new Array( iheight );
	blue[x]		= new Array( iheight );
	for( var y = 0 ; y < iheight && !zone.cancel() ; y++ )
	{
		red[x][y]	= 0;
		green[x][y]	= 0;
		blue[x][y]	= 0;
	}
}

var itrCount = 0;

MAIN:
while( itrCount < itr && !zone.cancel() )
{
	plot( 100000 );
	writeImage();
	if( itrCount + 1 < itr )
	{
		zone.sendSnapshot();
	}
	zone.beep();
	itrCount++;
}

//Functions
function rand(min,max)
{
	return min + ( Math.random() * ( Math.abs( max - min ) ) ) ;
}

function iterate(x0, y0, draw, clr, points)
{
	var x = 0.0;
	var y = 0.0;
	var x2= 0.0;
	var y2= 0.0;
	var ix= 0; //x point coordinate in image
	var iy= 0; //y point coordinate in image

	for( var c = 0 ; c < clr && !zone.cancel() ; c++ )
	{
		x2 = x * x - y * y + x0;
		y2 = 2 * x * y + y0;
		if( draw && c > 3 )
		{
			ix = parseInt( iheight * ( x2 + 2.0 ) / 3.0 );
			iy = parseInt( iwidth  * ( y2 + 1.5 ) / 3.0 );
			if( ix >= 0 && iy >= 0 && ix < iheight && iy < iwidth )
			{
				points[iy][ix]++;
			}
		}
		if( ( x2 * x2 + y2 * y2 ) > 4 )
		{
			return true;
		}
		x = x2;
		y = y2;
	}
	return false;
}

function plot(iteration)
{
	var x, y;
	for( var n = 0 ; n < iteration && !zone.cancel() ; n++ )
	{
		x = rand( -2.0, 1.0 );
		y = rand( -1.5, 1.5 );
		
		// red...
		if( iterate(x, y, false, __RED, red) )
		{
			iterate(x, y, true, __RED, red);
		}
		
		// green ...
		if( iterate(x, y, false, __GREEN, green) )
		{
			iterate(x, y, true, __GREEN, green);
		}
		
		// blue
		if( iterate(x, y, false, __BLUE, blue) )
		{
			iterate(x, y, true, __BLUE, blue);
		}
		
		if( n % 1000 == 0 )
		{
			zone.progress( n / 1000 );
		}
	}
}

function findMax()
{
	__MAXRED	= 0;
	__MAXGREEN	= 0;
	__MAXBLUE	= 0;
	for( var y = 0 ; y < iheight && !zone.cancel() ; y++ )
	{
		for( var x = 0 ; x < iwidth && !zone.cancel() ; x++ )
		{
			__MAXRED	= Math.max( __MAXRED	, red[x][y] );
			__MAXGREEN	= Math.max( __MAXGREEN	, green[x][y] );
			__MAXBLUE	= Math.max( __MAXBLUE	, blue[x][y] );
		}
	}
}

function writeImage()
{
	findMax();
	for( var y = 0 ; y < iheight && !zone.cancel() ; y++ )
	{
		for( var x = 0 ; x < iwidth && !zone.cancel() ; x++ )
		{
			var r = red[x][y] / (  __MAXRED	/ 2.5 );
			if( r > 1.0 )
			{
				r = 1.0;
			}
			var g = green[x][y] / (  __MAXGREEN	/ 2.5 );
			if( g > 1.0 )
			{
				g = 1.0;
			}
			var b = blue[x][y] / (  __MAXBLUE	/ 2.5 );
			if( b > 1.0 )
			{
				b = 1.0;
			}
			//~
			zone.setPixel(x, y, parseInt( r * 255 ), parseInt( g * 255 ), parseInt( b * 255 ) );
		}
	}
}
