/**
	by	::	Adrabi Abderrahim
	License	::	The Artistic License
*/

var MAX = 32;
var height = zone.getImageHeight();
var width = zone.getImageWidth();

var start = zone.getStartPoint();
var y = 0;
var i = 0;
var inc = zone.getIncrement();

while( y < height && !zone.cancel() )
{
    var x = start;
    while( x < width + start && !zone.cancel() )
    {
	
        var dx = 2.5 * x / width - 2.0;
        var dy = 1.25 - 2.5 * y / height;
        var value = mandel(dx, dy);

        value = value * 255 / MAX;
	

        zone.setPixel(x,y, (65536 * value) + (value * 256) + value );
	
        x += inc;
    }
   if( y % 0 == 0 )
   {
	zone.progress( (y / 4) );
   }
    y += 1;
}
//~ =)
if( !zone.cancel() )
{
	zone.progress( 100 );
}

function mandel(px,py) {
    var value = 0;
    var zx = 0.0, zy = 0.0, zx2 = 0.0, zy2 = 0.0;

    while (value < MAX && zx2 + zy2 < 4.0) {
      zy = 2.0 * zx * zy + py;
      zx = zx2 - zy2 + px;
      zx2 = zx * zx;
      zy2 = zy * zy;

      value++;
    }
    return MAX - value;
}
