/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _FRACTALPARAMETERS_H_
#define _FRACTALPARAMETERS_H_

#include "zone.h"

#include <QtCore/QSize>

/**
 * Paramtres d'une fractale.
 */
class FractalParameters
{
private:
	Zone m_zone;
	QSize m_image_size;
	quint64 m_points_number;
	unsigned int m_sequence_max;

public:
	/**
	 * \brief Constructeur par dfaut.
	 */
	FractalParameters()
		:	m_zone( -2.0, -2.0, 4.0, 4.0 )
	{
	}

	/**
	 * \brief Constructeur.
	 * \param _zone Zone de calcul de la fractale.
	 * \param _image_size Taille de l'image rsultante.
	 * \param _points_number Nombre de points  gnrer.
	 * \param _sequence_max Taille maximum d'une squence.
	 */
	FractalParameters( const Zone& _zone, const QSize& _image_size, const quint64 _points_number, const unsigned int _sequence_max )
		:	m_zone( _zone )
		,	m_image_size( _image_size )
		,	m_points_number( _points_number )
		,	m_sequence_max( _sequence_max )
	{
	}

	/**
	 * \brief Accs.
	 * \return Zone de la fractale.
	 */
	const Zone&			zone()			const { return m_zone; }
	/**
	 * \brief Accs.
	 * \return Taille de l'image rsultante.
	 */
	const QSize&		imageSize()		const { return m_image_size; }
	/**
	 * \brief Accs.
	 * \return Nombre de points  gnrer.
	 */
	quint64				pointsNumber()	const { return m_points_number; }
	/**
	 * \brief Accs.
	 * \return Taille maximum de la squence.
	 */
	unsigned int		sequenceMax()	const { return m_sequence_max; }

	/**
	 * \brief Accs.
	 * \param _zone Zone de la fractale.
	 */
	void setZone(			const Zone&			_zone			) { m_zone = _zone; }
	/**
	 * \brief Accs.
	 * \param _image_size Taille de l'image rsultante.
	 */
	void setImageSize(		const QSize&		_image_size		) { m_image_size = _image_size; }
	/**
	 * \brief Accs.
	 * \param _points_number Nombre de points  gnrer.
	 */
	void setPointsNumber(	const quint64		_points_number	) { m_points_number = _points_number; }
	/**
	 * \brief Accs.
	 * \param _sequence_max Taille maximum de la squence.
	 */
	void setSequenceMax(	const unsigned int	_sequence_max	) { m_sequence_max = _sequence_max; }
};

#endif //_FRACTALPARAMETERS_H_