/*Copyright (c) 2010 Maxime Petitjean

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to deal
in the Software without restriction, including without limitation the rights
to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
THE SOFTWARE.*/

#ifndef _CENTERACCUMULATOR_H_
#define _CENTERACCUMULATOR_H_

#include "../accumulator.h"

/**
 * Pour chaque squence gnre, cette classe va accumuler le nombre de points de la squence sur le premier point de celle-ci.
 */
class CenterAccumulator : public Accumulator
{
public:
	CenterAccumulator( const FractalParameters * _fractal_parameters )
		:	Accumulator( _fractal_parameters )
	{
	}

	void accumulate( const Point& _init_point, const PointsSequence& _sequence )
	{
		const unsigned int buffer_position = bufferPosition( _init_point );
		Q_ASSERT( buffer_position < m_buffer_size );
		
		m_buffer[ buffer_position ] += _sequence.size();
	} 
};

#endif //_CENTERACCUMULATOR_H_